/*
 * Decompiled with CFR 0.152.
 */
package com.bloock.sdk.client;

import com.bloock.sdk.bridge.Bridge;
import com.bloock.sdk.bridge.proto.BloockConfig;
import com.bloock.sdk.bridge.proto.BloockIdentity;
import com.bloock.sdk.bridge.proto.BloockShared;
import com.bloock.sdk.config.Config;
import com.bloock.sdk.entity.identity.Credential;
import com.bloock.sdk.entity.identity.CredentialBuilder;
import com.bloock.sdk.entity.identity.CredentialProof;
import com.bloock.sdk.entity.identity.DidMethod;
import com.bloock.sdk.entity.identity.Holder;
import com.bloock.sdk.entity.identity.Issuer;
import com.bloock.sdk.entity.identity.IssuerStateReceipt;
import com.bloock.sdk.entity.identity.PublishIntervalParams;
import com.bloock.sdk.entity.identity.Schema;
import com.bloock.sdk.entity.identity.SchemaBuilder;
import com.bloock.sdk.entity.identity.VerificationReceipt;
import com.bloock.sdk.entity.key.Key;

public class IdentityClient {
    private final Bridge bridge = new Bridge();
    private final BloockConfig.ConfigData configData;

    public IdentityClient() {
        this.configData = Config.newConfigDataDefault();
    }

    public IdentityClient(BloockConfig.ConfigData configData) {
        this.configData = Config.newConfigData(configData);
    }

    public Holder createHolder(Key holderKey, DidMethod didMethod) throws Exception {
        BloockIdentity.CreateHolderRequest.Builder builder = BloockIdentity.CreateHolderRequest.newBuilder().setKey(holderKey.toProto()).setDidMethod(didMethod.toProto()).setConfigData(this.configData);
        BloockIdentity.CreateHolderRequest request = builder.build();
        BloockIdentity.CreateHolderResponse response = this.bridge.getIdentity().createHolder(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return new Holder(response.getDid(), didMethod, holderKey);
    }

    public Issuer createIssuer(Key issuerKey, PublishIntervalParams publishInterval, DidMethod didMethod, String name, String description, String image) throws Exception {
        BloockIdentity.CreateIssuerRequest.Builder builder = BloockIdentity.CreateIssuerRequest.newBuilder().setKey(issuerKey.toProto()).setDidMethod(didMethod.toProto()).setPublishInterval(publishInterval.toProto()).setConfigData(this.configData);
        if (name != null) {
            builder.setName(name);
        }
        if (description != null) {
            builder.setDescription(description);
        }
        if (image != null) {
            builder.setImage(image);
        }
        BloockIdentity.CreateIssuerRequest request = builder.build();
        BloockIdentity.CreateIssuerResponse response = this.bridge.getIdentity().createIssuer(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return new Issuer(response.getDid(), didMethod, issuerKey);
    }

    public Issuer importIssuer(Key issuerKey, DidMethod didMethod) throws Exception {
        BloockIdentity.ImportIssuerRequest request = BloockIdentity.ImportIssuerRequest.newBuilder().setKey(issuerKey.toProto()).setDidMethod(didMethod.toProto()).setConfigData(this.configData).build();
        BloockIdentity.ImportIssuerResponse response = this.bridge.getIdentity().importIssuer(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return new Issuer(response.getDid(), didMethod, issuerKey);
    }

    public SchemaBuilder buildSchema(String displayName, String schemaType, String version, String description) throws Exception {
        return new SchemaBuilder(displayName, schemaType, version, description, this.configData);
    }

    public Schema getSchema(String id) throws Exception {
        BloockIdentity.GetSchemaRequest request = BloockIdentity.GetSchemaRequest.newBuilder().setConfigData(this.configData).setId(id).build();
        BloockIdentity.GetSchemaResponse response = this.bridge.getIdentity().getSchema(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return Schema.fromProto(response.getSchema());
    }

    public CredentialBuilder buildCredential(Issuer issuer, String schemaId, String holderDid, Long expiration, int version) throws Exception {
        return new CredentialBuilder(issuer, schemaId, holderDid, expiration, version, this.configData);
    }

    public Credential getCredential(String credentialId) throws Exception {
        BloockIdentity.GetCredentialRequest request = BloockIdentity.GetCredentialRequest.newBuilder().setConfigData(this.configData).setCredentialId(credentialId).build();
        BloockIdentity.GetCredentialResponse response = this.bridge.getIdentity().getCredential(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return Credential.fromProto(response.getCredential());
    }

    public String getCredentialOffer(Issuer issuer, String credentialId) throws Exception {
        BloockIdentity.GetCredentialOfferRequest request = BloockIdentity.GetCredentialOfferRequest.newBuilder().setConfigData(this.configData).setCredentialId(credentialId).setKey(issuer.getKey().toProto()).build();
        BloockIdentity.GetCredentialOfferResponse response = this.bridge.getIdentity().getCredentialOffer(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return response.getCredentialOffer();
    }

    public IssuerStateReceipt forcePublishIssuerState(Issuer issuer) throws Exception {
        BloockIdentity.ForcePublishIssuerStateRequest req = BloockIdentity.ForcePublishIssuerStateRequest.newBuilder().setConfigData(this.configData).setIssuerDid(issuer.getDid().getDid()).setKey(issuer.getKey().toProto()).build();
        BloockIdentity.ForcePublishIssuerStateResponse response = this.bridge.getIdentity().forcePublishIssuerState(req);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return IssuerStateReceipt.fromProto(response.getStateReceipt());
    }

    public CredentialProof getCredentialProof(String issuerDid, String credentialId) throws Exception {
        BloockIdentity.GetCredentialProofRequest request = BloockIdentity.GetCredentialProofRequest.newBuilder().setCredentialId(credentialId).setIssuerDid(issuerDid).setConfigData(this.configData).build();
        BloockIdentity.GetCredentialProofResponse response = this.bridge.getIdentity().getCredentialProof(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return CredentialProof.fromProto(response.getProof());
    }

    public boolean revokeCredential(Credential credential, Issuer issuer) throws Exception {
        BloockIdentity.RevokeCredentialRequest request = BloockIdentity.RevokeCredentialRequest.newBuilder().setConfigData(this.configData).setCredential(credential.toProto()).setKey(issuer.getKey().toProto()).build();
        BloockIdentity.RevokeCredentialResponse response = this.bridge.getIdentity().revokeCredential(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return response.getResult().getSuccess();
    }

    public VerificationReceipt createVerification(String proofRequest) throws Exception {
        BloockIdentity.CreateVerificationRequest request = BloockIdentity.CreateVerificationRequest.newBuilder().setConfigData(this.configData).setProofRequest(proofRequest).build();
        BloockIdentity.CreateVerificationResponse response = this.bridge.getIdentity().createVerification(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return VerificationReceipt.fromProto(response.getResult());
    }

    public boolean waitVerification(long sessionID, long timeout) throws Exception {
        BloockIdentity.WaitVerificationRequest request = BloockIdentity.WaitVerificationRequest.newBuilder().setConfigData(this.configData).setSessionId(sessionID).setTimeout(timeout).build();
        BloockIdentity.WaitVerificationResponse response = this.bridge.getIdentity().waitVerification(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return response.getStatus();
    }

    public boolean getVerificationStatus(long sessionID) throws Exception {
        BloockIdentity.GetVerificationStatusRequest request = BloockIdentity.GetVerificationStatusRequest.newBuilder().setConfigData(this.configData).setSessionId(sessionID).build();
        BloockIdentity.GetVerificationStatusResponse response = this.bridge.getIdentity().getVerificationStatus(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return response.getStatus();
    }
}

