/*
 * Decompiled with CFR 0.152.
 */
package com.bloock.sdk.client;

import com.bloock.sdk.bridge.Bridge;
import com.bloock.sdk.bridge.proto.BloockConfig;
import com.bloock.sdk.bridge.proto.BloockIntegrity;
import com.bloock.sdk.bridge.proto.BloockShared;
import com.bloock.sdk.config.Config;
import com.bloock.sdk.entity.integrity.Anchor;
import com.bloock.sdk.entity.integrity.Network;
import com.bloock.sdk.entity.integrity.Proof;
import com.bloock.sdk.entity.integrity.RecordReceipt;
import com.bloock.sdk.entity.record.Record;
import java.util.List;
import java.util.stream.Collectors;

public class IntegrityClient {
    private final Bridge bridge = new Bridge();
    private final BloockConfig.ConfigData configData;

    public IntegrityClient() {
        this.configData = Config.newConfigDataDefault();
    }

    public IntegrityClient(BloockConfig.ConfigData configData) {
        this.configData = Config.newConfigData(configData);
    }

    public List<RecordReceipt> sendRecords(List<Record> records) throws Exception {
        BloockIntegrity.SendRecordsRequest request = BloockIntegrity.SendRecordsRequest.newBuilder().setConfigData(this.configData).addAllRecords(records.stream().map(x -> x.toProto()).collect(Collectors.toList())).build();
        BloockIntegrity.SendRecordsResponse response = this.bridge.getIntegrity().sendRecords(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return response.getRecordsList().stream().map(x -> RecordReceipt.fromProto(x)).collect(Collectors.toList());
    }

    public Anchor getAnchor(long id) throws Exception {
        BloockIntegrity.GetAnchorRequest request = BloockIntegrity.GetAnchorRequest.newBuilder().setConfigData(this.configData).setAnchorId(id).build();
        BloockIntegrity.GetAnchorResponse response = this.bridge.getIntegrity().getAnchor(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return Anchor.fromProto(response.getAnchor());
    }

    public Anchor waitAnchor(long id) throws Exception {
        return this.waitAnchor(id, 120000L);
    }

    public Anchor waitAnchor(long id, long timeout) throws Exception {
        BloockIntegrity.WaitAnchorRequest request = BloockIntegrity.WaitAnchorRequest.newBuilder().setConfigData(this.configData).setAnchorId(id).setTimeout(timeout).build();
        BloockIntegrity.WaitAnchorResponse response = this.bridge.getIntegrity().waitAnchor(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return Anchor.fromProto(response.getAnchor());
    }

    public Proof getProof(List<Record> records) throws Exception {
        BloockIntegrity.GetProofRequest request = BloockIntegrity.GetProofRequest.newBuilder().setConfigData(this.configData).addAllRecords(records.stream().map(x -> x.toProto()).collect(Collectors.toList())).build();
        BloockIntegrity.GetProofResponse response = this.bridge.getIntegrity().getProof(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return Proof.fromProto(response.getProof());
    }

    public String verifyProof(Proof proof) throws Exception {
        BloockIntegrity.VerifyProofRequest request = BloockIntegrity.VerifyProofRequest.newBuilder().setConfigData(this.configData).setProof(proof.toProto()).build();
        BloockIntegrity.VerifyProofResponse response = this.bridge.getIntegrity().verifyProof(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return response.getRecord();
    }

    public long verifyRecords(List<Record> records) throws Exception {
        return this.verifyRecords(records, null);
    }

    public long verifyRecords(List<Record> records, Network network) throws Exception {
        BloockIntegrity.VerifyRecordsRequest.Builder builder = BloockIntegrity.VerifyRecordsRequest.newBuilder().setConfigData(this.configData).addAllRecords(records.stream().map(x -> x.toProto()).collect(Collectors.toList()));
        if (network != null) {
            builder.setNetwork(network.toProto());
        }
        BloockIntegrity.VerifyRecordsRequest request = builder.build();
        BloockIntegrity.VerifyRecordsResponse response = this.bridge.getIntegrity().verifyRecords(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return response.getTimestamp();
    }

    public long validateRoot(String root, Network network) throws Exception {
        BloockIntegrity.ValidateRootRequest request = BloockIntegrity.ValidateRootRequest.newBuilder().setConfigData(this.configData).setRoot(root).setNetwork(network.toProto()).build();
        BloockIntegrity.ValidateRootResponse response = this.bridge.getIntegrity().validateRoot(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return response.getTimestamp();
    }
}

