/*
 * Decompiled with CFR 0.152.
 */
package com.bloock.sdk.client;

import com.bloock.sdk.bridge.Bridge;
import com.bloock.sdk.bridge.proto.BloockConfig;
import com.bloock.sdk.bridge.proto.BloockKeys;
import com.bloock.sdk.bridge.proto.BloockShared;
import com.bloock.sdk.config.Config;
import com.bloock.sdk.entity.key.CertificateType;
import com.bloock.sdk.entity.key.ImportCertificateParams;
import com.bloock.sdk.entity.key.KeyType;
import com.bloock.sdk.entity.key.LocalCertificate;
import com.bloock.sdk.entity.key.LocalCertificateParams;
import com.bloock.sdk.entity.key.LocalKey;
import com.bloock.sdk.entity.key.Managed;
import com.bloock.sdk.entity.key.ManagedCertificate;
import com.bloock.sdk.entity.key.ManagedCertificateParams;
import com.bloock.sdk.entity.key.ManagedKey;
import com.bloock.sdk.entity.key.ManagedKeyParams;
import com.bloock.sdk.entity.key.TotpAccessControlReceipt;
import com.google.protobuf.ByteString;
import java.util.List;

public class KeyClient {
    private final Bridge bridge = new Bridge();
    private final BloockConfig.ConfigData configData;

    public KeyClient() {
        this.configData = Config.newConfigDataDefault();
    }

    public KeyClient(BloockConfig.ConfigData configData) {
        this.configData = Config.newConfigData(configData);
    }

    public LocalKey newLocalKey(KeyType keyType) throws Exception {
        BloockKeys.GenerateLocalKeyRequest request = BloockKeys.GenerateLocalKeyRequest.newBuilder().setConfigData(this.configData).setKeyType(keyType.toProto()).build();
        BloockKeys.GenerateLocalKeyResponse response = this.bridge.getKey().generateLocalKey(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return LocalKey.fromProto(response.getLocalKey());
    }

    public LocalKey loadLocalKey(KeyType keyType, String key) throws Exception {
        BloockKeys.LoadLocalKeyRequest request = BloockKeys.LoadLocalKeyRequest.newBuilder().setConfigData(this.configData).setKeyType(keyType.toProto()).setKey(key).build();
        BloockKeys.LoadLocalKeyResponse response = this.bridge.getKey().loadLocalKey(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return LocalKey.fromProto(response.getLocalKey());
    }

    public ManagedKey newManagedKey(ManagedKeyParams params) throws Exception {
        BloockKeys.GenerateManagedKeyRequest request = BloockKeys.GenerateManagedKeyRequest.newBuilder().setConfigData(this.configData).setParams(params.toProto()).build();
        BloockKeys.GenerateManagedKeyResponse response = this.bridge.getKey().generateManagedKey(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return ManagedKey.fromProto(response.getManagedKey());
    }

    public ManagedKey loadManagedKey(String id) throws Exception {
        BloockKeys.LoadManagedKeyRequest request = BloockKeys.LoadManagedKeyRequest.newBuilder().setConfigData(this.configData).setId(id).build();
        BloockKeys.LoadManagedKeyResponse response = this.bridge.getKey().loadManagedKey(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return ManagedKey.fromProto(response.getManagedKey());
    }

    public LocalCertificate newLocalCertificate(LocalCertificateParams params) throws Exception {
        BloockKeys.GenerateLocalCertificateRequest request = BloockKeys.GenerateLocalCertificateRequest.newBuilder().setConfigData(this.configData).setParams(params.toProto()).build();
        BloockKeys.GenerateLocalCertificateResponse response = this.bridge.getKey().generateLocalCertificate(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return LocalCertificate.fromProto(response.getLocalCertificate());
    }

    public LocalCertificate loadLocalCertificate(byte[] pkcs12, String password) throws Exception {
        BloockKeys.LoadLocalCertificateRequest request = BloockKeys.LoadLocalCertificateRequest.newBuilder().setConfigData(this.configData).setPkcs12(ByteString.copyFrom((byte[])pkcs12)).setPassword(password).build();
        BloockKeys.LoadLocalCertificateResponse response = this.bridge.getKey().loadLocalCertificate(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return LocalCertificate.fromProto(response.getLocalCertificate());
    }

    public ManagedCertificate newManagedCertificate(ManagedCertificateParams params) throws Exception {
        BloockKeys.GenerateManagedCertificateRequest request = BloockKeys.GenerateManagedCertificateRequest.newBuilder().setConfigData(this.configData).setParams(params.toProto()).build();
        BloockKeys.GenerateManagedCertificateResponse response = this.bridge.getKey().generateManagedCertificate(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return ManagedCertificate.fromProto(response.getManagedCertificate());
    }

    public ManagedCertificate loadManagedCertificate(String id) throws Exception {
        BloockKeys.LoadManagedCertificateRequest request = BloockKeys.LoadManagedCertificateRequest.newBuilder().setConfigData(this.configData).setId(id).build();
        BloockKeys.LoadManagedCertificateResponse response = this.bridge.getKey().loadManagedCertificate(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return ManagedCertificate.fromProto(response.getManagedCertificate());
    }

    public ManagedCertificate importManagedCertificate(CertificateType type, byte[] certificate, ImportCertificateParams params) throws Exception {
        BloockKeys.ImportManagedCertificateRequest.Builder builder = BloockKeys.ImportManagedCertificateRequest.newBuilder().setConfigData(this.configData).setCertificateType(type.toProto()).setCertificate(ByteString.copyFrom((byte[])certificate));
        if (params.getPassword() != null) {
            builder.setPassword(params.getPassword());
        }
        BloockKeys.ImportManagedCertificateRequest request = builder.build();
        BloockKeys.ImportManagedCertificateResponse response = this.bridge.getKey().importManagedCertificate(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return ManagedCertificate.fromProto(response.getManagedCertificate());
    }

    public TotpAccessControlReceipt setupTotpAccessControl(Managed key) throws Exception {
        BloockKeys.SetupTotpAccessControlRequest.Builder builder = BloockKeys.SetupTotpAccessControlRequest.newBuilder().setConfigData(this.configData);
        if (key.getManagedKey() != null) {
            builder.setManagedKey(key.getManagedKey().toProto());
        }
        if (key.getManagedCertificate() != null) {
            builder.setManagedCertificate(key.getManagedCertificate().toProto());
        }
        BloockKeys.SetupTotpAccessControlRequest request = builder.build();
        BloockKeys.SetupTotpAccessControlResponse response = this.bridge.getKey().setupTotpAccessControl(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return new TotpAccessControlReceipt(response.getSecret(), response.getSecretQr(), (List<String>)response.getRecoveryCodesList());
    }

    public TotpAccessControlReceipt recoverTotpAccessControl(Managed key, String code) throws Exception {
        BloockKeys.RecoverTotpAccessControlRequest.Builder builder = BloockKeys.RecoverTotpAccessControlRequest.newBuilder().setConfigData(this.configData).setCode(code);
        if (key.getManagedKey() != null) {
            builder.setManagedKey(key.getManagedKey().toProto());
        }
        if (key.getManagedCertificate() != null) {
            builder.setManagedCertificate(key.getManagedCertificate().toProto());
        }
        BloockKeys.RecoverTotpAccessControlRequest request = builder.build();
        BloockKeys.RecoverTotpAccessControlResponse response = this.bridge.getKey().recoverTotpAccessControl(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return new TotpAccessControlReceipt(response.getSecret(), response.getSecretQr(), (List<String>)response.getRecoveryCodesList());
    }

    public void setupSecretAccessControl(Managed key, String secret, String email) throws Exception {
        BloockKeys.SetupSecretAccessControlRequest.Builder builder = BloockKeys.SetupSecretAccessControlRequest.newBuilder().setConfigData(this.configData).setSecret(secret).setEmail(email);
        if (key.getManagedKey() != null) {
            builder.setManagedKey(key.getManagedKey().toProto());
        }
        if (key.getManagedCertificate() != null) {
            builder.setManagedCertificate(key.getManagedCertificate().toProto());
        }
        BloockKeys.SetupSecretAccessControlRequest request = builder.build();
        BloockKeys.SetupSecretAccessControlResponse response = this.bridge.getKey().setupSecretAccessControl(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
    }
}

