/*
 * Decompiled with CFR 0.152.
 */
package com.bloock.sdk.client;

import com.bloock.sdk.bridge.Bridge;
import com.bloock.sdk.bridge.proto.BloockAuthenticityEntities;
import com.bloock.sdk.bridge.proto.BloockAvailabilityEntities;
import com.bloock.sdk.bridge.proto.BloockConfig;
import com.bloock.sdk.bridge.proto.BloockEncryptionEntities;
import com.bloock.sdk.bridge.proto.BloockRecord;
import com.bloock.sdk.bridge.proto.BloockRecordEntities;
import com.bloock.sdk.bridge.proto.BloockShared;
import com.bloock.sdk.entity.authenticity.Signer;
import com.bloock.sdk.entity.encryption.Encrypter;
import com.bloock.sdk.entity.record.Record;
import com.bloock.sdk.entity.record.RecordDetails;
import com.google.protobuf.ByteString;

public class RecordBuilder {
    Object payload;
    BloockRecordEntities.RecordTypes type;
    BloockConfig.ConfigData configData;
    BloockAuthenticityEntities.Signer signer;
    BloockEncryptionEntities.Encrypter encrypter;
    BloockEncryptionEntities.Encrypter decrypter;

    RecordBuilder(Object payload, BloockRecordEntities.RecordTypes type, BloockConfig.ConfigData configData) {
        this.payload = payload;
        this.type = type;
        this.configData = configData;
    }

    public RecordBuilder withSigner(Signer signer) {
        this.signer = signer.toProto();
        return this;
    }

    public RecordBuilder withEncrypter(Encrypter encrypter) {
        this.encrypter = encrypter.toProto();
        return this;
    }

    public RecordBuilder withDecrypter(Encrypter decrypter) {
        this.decrypter = decrypter.toProto();
        return this;
    }

    public Record build() throws Exception {
        BloockRecord.RecordBuilderResponse response;
        Bridge bridge = new Bridge();
        switch (this.type) {
            case BYTES: {
                BloockRecord.RecordBuilderFromBytesRequest.Builder builder = BloockRecord.RecordBuilderFromBytesRequest.newBuilder().setConfigData(this.configData).setPayload(ByteString.copyFrom((byte[])((byte[])this.payload)));
                if (this.signer != null) {
                    builder.setSigner(this.signer);
                }
                if (this.encrypter != null) {
                    builder.setEncrypter(this.encrypter);
                }
                if (this.decrypter != null) {
                    builder.setDecrypter(this.decrypter);
                }
                response = bridge.getRecord().buildRecordFromBytes(builder.build());
                break;
            }
            case FILE: {
                BloockRecord.RecordBuilderFromFileRequest.Builder builder = BloockRecord.RecordBuilderFromFileRequest.newBuilder().setConfigData(this.configData).setPayload(ByteString.copyFrom((byte[])((byte[])this.payload)));
                if (this.signer != null) {
                    builder.setSigner(this.signer);
                }
                if (this.encrypter != null) {
                    builder.setEncrypter(this.encrypter);
                }
                if (this.decrypter != null) {
                    builder.setDecrypter(this.decrypter);
                }
                response = bridge.getRecord().buildRecordFromFile(builder.build());
                break;
            }
            case HEX: {
                BloockRecord.RecordBuilderFromHexRequest.Builder builder = BloockRecord.RecordBuilderFromHexRequest.newBuilder().setConfigData(this.configData).setPayload((String)this.payload);
                if (this.signer != null) {
                    builder.setSigner(this.signer);
                }
                if (this.encrypter != null) {
                    builder.setEncrypter(this.encrypter);
                }
                if (this.decrypter != null) {
                    builder.setDecrypter(this.decrypter);
                }
                response = bridge.getRecord().buildRecordFromHex(builder.build());
                break;
            }
            case JSON: {
                BloockRecord.RecordBuilderFromJSONRequest.Builder builder = BloockRecord.RecordBuilderFromJSONRequest.newBuilder().setConfigData(this.configData).setPayload((String)this.payload);
                if (this.signer != null) {
                    builder.setSigner(this.signer);
                }
                if (this.encrypter != null) {
                    builder.setEncrypter(this.encrypter);
                }
                if (this.decrypter != null) {
                    builder.setDecrypter(this.decrypter);
                }
                response = bridge.getRecord().buildRecordFromJson(builder.build());
                break;
            }
            case RECORD: {
                BloockRecord.RecordBuilderFromRecordRequest.Builder builder = BloockRecord.RecordBuilderFromRecordRequest.newBuilder().setConfigData(this.configData).setPayload((BloockRecordEntities.Record)this.payload);
                if (this.signer != null) {
                    builder.setSigner(this.signer);
                }
                if (this.encrypter != null) {
                    builder.setEncrypter(this.encrypter);
                }
                if (this.decrypter != null) {
                    builder.setDecrypter(this.decrypter);
                }
                response = bridge.getRecord().buildRecordFromRecord(builder.build());
                break;
            }
            case STRING: {
                BloockRecord.RecordBuilderFromStringRequest.Builder builder = BloockRecord.RecordBuilderFromStringRequest.newBuilder().setConfigData(this.configData).setPayload((String)this.payload);
                if (this.signer != null) {
                    builder.setSigner(this.signer);
                }
                if (this.encrypter != null) {
                    builder.setEncrypter(this.encrypter);
                }
                if (this.decrypter != null) {
                    builder.setDecrypter(this.decrypter);
                }
                response = bridge.getRecord().buildRecordFromString(builder.build());
                break;
            }
            case LOADER: {
                BloockRecord.RecordBuilderFromLoaderRequest.Builder builder = BloockRecord.RecordBuilderFromLoaderRequest.newBuilder().setConfigData(this.configData).setLoader((BloockAvailabilityEntities.Loader)this.payload);
                if (this.signer != null) {
                    builder.setSigner(this.signer);
                }
                if (this.encrypter != null) {
                    builder.setEncrypter(this.encrypter);
                }
                if (this.decrypter != null) {
                    builder.setDecrypter(this.decrypter);
                }
                response = bridge.getRecord().buildRecordFromLoader(builder.build());
                break;
            }
            default: {
                throw new Exception("Invalid type");
            }
        }
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return Record.fromProto(response.getRecord(), this.configData);
    }

    public RecordDetails getDetails() throws Exception {
        Bridge bridge = new Bridge();
        BloockRecord.GetDetailsRequest.Builder builder = BloockRecord.GetDetailsRequest.newBuilder().setConfigData(this.configData).setPayload(ByteString.copyFrom((byte[])((byte[])this.payload)));
        BloockRecord.GetDetailsResponse response = bridge.getRecord().getDetails(builder.build());
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return RecordDetails.fromProto(response.getDetails());
    }
}

