/*
 * Decompiled with CFR 0.152.
 */
package com.bloock.sdk.client;

import com.bloock.sdk.bridge.proto.BloockConfig;
import com.bloock.sdk.bridge.proto.BloockRecordEntities;
import com.bloock.sdk.client.RecordBuilder;
import com.bloock.sdk.config.Config;
import com.bloock.sdk.entity.availability.Loader;
import com.bloock.sdk.entity.record.Record;

public class RecordClient {
    private final BloockConfig.ConfigData configData;

    public RecordClient() {
        this.configData = Config.newConfigDataDefault();
    }

    public RecordClient(BloockConfig.ConfigData configData) {
        this.configData = Config.newConfigData(configData);
    }

    public RecordBuilder fromRecord(Record record) {
        return new RecordBuilder(record.toProto(), BloockRecordEntities.RecordTypes.RECORD, this.configData);
    }

    public RecordBuilder fromLoader(Loader loader) {
        return new RecordBuilder(loader.toProto(), BloockRecordEntities.RecordTypes.LOADER, this.configData);
    }

    public RecordBuilder fromString(String str) {
        return new RecordBuilder(str, BloockRecordEntities.RecordTypes.STRING, this.configData);
    }

    public RecordBuilder fromHex(String str) {
        return new RecordBuilder(str, BloockRecordEntities.RecordTypes.HEX, this.configData);
    }

    public RecordBuilder fromJson(String json) {
        return new RecordBuilder(json, BloockRecordEntities.RecordTypes.JSON, this.configData);
    }

    public RecordBuilder fromFile(byte[] file) {
        return new RecordBuilder(file, BloockRecordEntities.RecordTypes.FILE, this.configData);
    }

    public RecordBuilder fromBytes(byte[] bytes) {
        return new RecordBuilder(bytes, BloockRecordEntities.RecordTypes.BYTES, this.configData);
    }
}

