/*
 * Decompiled with CFR 0.152.
 */
package com.bloock.sdk.client;

import com.bloock.sdk.bridge.Bridge;
import com.bloock.sdk.bridge.proto.BloockConfig;
import com.bloock.sdk.bridge.proto.BloockShared;
import com.bloock.sdk.bridge.proto.BloockWebhook;
import com.bloock.sdk.config.Config;
import com.google.protobuf.ByteString;

public class WebhookClient {
    private final Bridge bridge = new Bridge();
    private final BloockConfig.ConfigData configData;

    public WebhookClient() {
        this.configData = Config.newConfigDataDefault();
    }

    public WebhookClient(BloockConfig.ConfigData configData) {
        this.configData = Config.newConfigData(configData);
    }

    public boolean verifyWebhookSignature(byte[] payload, String header, String secretKey, boolean enforceTolerance) throws Exception {
        BloockWebhook.VerifyWebhookSignatureRequest request = BloockWebhook.VerifyWebhookSignatureRequest.newBuilder().setConfigData(this.configData).setPayload(ByteString.copyFrom((byte[])payload)).setHeader(header).setSecretKey(secretKey).setEnforceTolerance(enforceTolerance).build();
        BloockWebhook.VerifyWebhookSignatureResponse response = this.bridge.getWebhook().verifyWebhookSignature(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return response.getIsValid();
    }
}

