/*
 * Decompiled with CFR 0.152.
 */
package com.bloock.sdk.entity.identity;

import com.bloock.sdk.bridge.Bridge;
import com.bloock.sdk.bridge.proto.BloockIdentity;
import com.bloock.sdk.bridge.proto.BloockIdentityEntities;
import com.bloock.sdk.bridge.proto.BloockShared;
import com.bloock.sdk.config.Config;
import com.bloock.sdk.entity.identity.CredentialProof;
import com.bloock.sdk.entity.identity.CredentialSchema;
import com.bloock.sdk.entity.identity.CredentialStatus;
import java.util.List;

public class Credential {
    private final List<String> context;
    private final String id;
    private final List<String> type;
    private final String issuanceDate;
    private final String expiration;
    private final String credentialSubject;
    private final CredentialStatus credentialStatus;
    private final String issuer;
    private final CredentialSchema credentialSchema;
    private final CredentialProof proof;

    public Credential(List<String> context, String id, List<String> type, String issuanceDate, String expiration, String credentialSubject, CredentialStatus credentialStatus, String issuer, CredentialSchema credentialSchema, CredentialProof proof) {
        this.context = context;
        this.id = id;
        this.type = type;
        this.issuanceDate = issuanceDate;
        this.expiration = expiration;
        this.credentialSubject = credentialSubject;
        this.credentialStatus = credentialStatus;
        this.issuer = issuer;
        this.credentialSchema = credentialSchema;
        this.proof = proof;
    }

    public static Credential fromProto(BloockIdentityEntities.Credential res) {
        return new Credential((List<String>)res.getContextList(), res.getId(), (List<String>)res.getTypeList(), res.getIssuanceDate(), res.getExpiration(), res.getCredentialSubject(), CredentialStatus.fromProto(res.getCredentialStatus()), res.getIssuer(), CredentialSchema.fromProto(res.getCredentialSchema()), CredentialProof.fromProto(res.getProof()));
    }

    public BloockIdentityEntities.Credential toProto() {
        return BloockIdentityEntities.Credential.newBuilder().addAllContext(this.context).setId(this.id).addAllType(this.type).setIssuanceDate(this.issuanceDate).setExpiration(this.expiration).setCredentialSubject(this.credentialSubject).setCredentialStatus(this.credentialStatus.toProto()).setIssuer(this.issuer).setCredentialSchema(this.credentialSchema.toProto()).setProof(this.proof.toProto()).build();
    }

    public static Credential fromJson(String json) throws Exception {
        Bridge bridge = new Bridge();
        BloockIdentity.CredentialFromJsonRequest req = BloockIdentity.CredentialFromJsonRequest.newBuilder().setConfigData(Config.newConfigDataDefault()).setJson(json).build();
        BloockIdentity.CredentialFromJsonResponse response = bridge.getIdentity().credentialFromJson(req);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return Credential.fromProto(response.getCredential());
    }

    public String toJson() throws Exception {
        Bridge bridge = new Bridge();
        BloockIdentity.CredentialToJsonRequest req = BloockIdentity.CredentialToJsonRequest.newBuilder().setConfigData(Config.newConfigDataDefault()).setCredential(this.toProto()).build();
        BloockIdentity.CredentialToJsonResponse response = bridge.getIdentity().credentialToJson(req);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return response.getJson();
    }

    public List<String> getContext() {
        return this.context;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getType() {
        return this.type;
    }

    public String getIssuanceDate() {
        return this.issuanceDate;
    }

    public String getExpiration() {
        return this.expiration;
    }

    public String getCredentialSubject() {
        return this.credentialSubject;
    }

    public CredentialStatus getCredentialStatus() {
        return this.credentialStatus;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public CredentialSchema getCredentialSchema() {
        return this.credentialSchema;
    }

    public CredentialProof getProof() {
        return this.proof;
    }
}

