/*
 * Decompiled with CFR 0.152.
 */
package com.bloock.sdk.entity.identity;

import com.bloock.sdk.bridge.Bridge;
import com.bloock.sdk.bridge.proto.BloockConfig;
import com.bloock.sdk.bridge.proto.BloockIdentity;
import com.bloock.sdk.bridge.proto.BloockIdentityEntities;
import com.bloock.sdk.bridge.proto.BloockKeysEntities;
import com.bloock.sdk.bridge.proto.BloockShared;
import com.bloock.sdk.entity.identity.BooleanAttribute;
import com.bloock.sdk.entity.identity.CredentialReceipt;
import com.bloock.sdk.entity.identity.DateAttribute;
import com.bloock.sdk.entity.identity.DatetimeAttribute;
import com.bloock.sdk.entity.identity.DecimalAttribute;
import com.bloock.sdk.entity.identity.IntegerAttribute;
import com.bloock.sdk.entity.identity.Issuer;
import com.bloock.sdk.entity.identity.StringAttribute;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

public class CredentialBuilder {
    private final String schemaId;
    private final String holderKey;
    private final Long expiration;
    private final int version;
    private BloockKeysEntities.Key key;
    private final BloockConfig.ConfigData configData;
    private final List<BloockIdentityEntities.BooleanAttribute> booleanAttributes;
    private final List<BloockIdentityEntities.DateAttribute> dateAttributes;
    private final List<BloockIdentityEntities.DateTimeAttribute> datetimeAttributes;
    private final List<BloockIdentityEntities.StringAttribute> stringAttributes;
    private final List<BloockIdentityEntities.IntegerAttribute> integerAttributes;
    private final List<BloockIdentityEntities.DecimalAttribute> decimalAttributes;

    public CredentialBuilder(Issuer issuer, String schemaId, String holderKey, Long expiration, int version, BloockConfig.ConfigData configData) {
        this.schemaId = schemaId;
        this.holderKey = holderKey;
        this.expiration = expiration;
        this.version = version;
        this.key = issuer.getKey().toProto();
        this.configData = configData;
        this.booleanAttributes = new ArrayList<BloockIdentityEntities.BooleanAttribute>();
        this.dateAttributes = new ArrayList<BloockIdentityEntities.DateAttribute>();
        this.datetimeAttributes = new ArrayList<BloockIdentityEntities.DateTimeAttribute>();
        this.stringAttributes = new ArrayList<BloockIdentityEntities.StringAttribute>();
        this.integerAttributes = new ArrayList<BloockIdentityEntities.IntegerAttribute>();
        this.decimalAttributes = new ArrayList<BloockIdentityEntities.DecimalAttribute>();
    }

    public CredentialBuilder withStringAttribute(String key, String value) {
        this.stringAttributes.add(new StringAttribute(key, value).toProto());
        return this;
    }

    public CredentialBuilder withIntegerAttribute(String key, Long value) {
        this.integerAttributes.add(new IntegerAttribute(key, value).toProto());
        return this;
    }

    public CredentialBuilder withDecimalAttribute(String key, double value) {
        this.decimalAttributes.add(new DecimalAttribute(key, value).toProto());
        return this;
    }

    public CredentialBuilder withBooleanAttribute(String key, boolean value) {
        this.booleanAttributes.add(new BooleanAttribute(key, value).toProto());
        return this;
    }

    public CredentialBuilder withDateAttribute(String key, LocalDate value) {
        this.dateAttributes.add(new DateAttribute(key, value).toProto());
        return this;
    }

    public CredentialBuilder withDatetimeAttribute(String key, LocalDateTime value) {
        this.datetimeAttributes.add(new DatetimeAttribute(key, value).toProto());
        return this;
    }

    public CredentialReceipt build() throws Exception {
        Bridge bridge = new Bridge();
        BloockIdentity.CreateCredentialRequest req = BloockIdentity.CreateCredentialRequest.newBuilder().setConfigData(this.configData).setSchemaId(this.schemaId).setHolderDid(this.holderKey).setExpiration(this.expiration).setVersion(this.version).setKey(this.key).addAllStringAttributes(this.stringAttributes).addAllIntegerAttributes(this.integerAttributes).addAllDecimalAttributes(this.decimalAttributes).addAllBooleanAttributes(this.booleanAttributes).addAllDateAttributes(this.dateAttributes).addAllDatetimeAttributes(this.datetimeAttributes).build();
        BloockIdentity.CreateCredentialResponse response = bridge.getIdentity().createCredential(req);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return CredentialReceipt.fromProto(response.getCredentialReceipt());
    }
}

