/*
 * Decompiled with CFR 0.152.
 */
package com.bloock.sdk.entity.identity;

import com.bloock.sdk.bridge.proto.BloockIdentityEntities;
import com.bloock.sdk.entity.identity.Attribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class DatetimeAttribute
extends Attribute<LocalDateTime> {
    public DatetimeAttribute(String id, LocalDateTime value) {
        super(id, value);
    }

    public static DatetimeAttribute fromProto(BloockIdentityEntities.DateTimeAttribute res) {
        LocalDateTime parsedDate = LocalDateTime.parse(res.getValue());
        return new DatetimeAttribute(res.getId(), parsedDate);
    }

    public BloockIdentityEntities.DateTimeAttribute toProto() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String formattedDate = ((LocalDateTime)this.value).format(formatter);
        return BloockIdentityEntities.DateTimeAttribute.newBuilder().setId(this.id).setValue(formattedDate).build();
    }
}

