/*
 * Decompiled with CFR 0.152.
 */
package com.bloock.sdk.entity.identity;

import com.bloock.sdk.bridge.Bridge;
import com.bloock.sdk.bridge.proto.BloockConfig;
import com.bloock.sdk.bridge.proto.BloockIdentity;
import com.bloock.sdk.bridge.proto.BloockIdentityEntities;
import com.bloock.sdk.bridge.proto.BloockShared;
import com.bloock.sdk.entity.identity.BooleanAttributeDescriptor;
import com.bloock.sdk.entity.identity.DateAttributeDescriptor;
import com.bloock.sdk.entity.identity.DatetimeAttributeDescriptor;
import com.bloock.sdk.entity.identity.DecimalAttributeDescriptor;
import com.bloock.sdk.entity.identity.DecimalEnumAttributeDescriptor;
import com.bloock.sdk.entity.identity.IntegerAttributeDescriptor;
import com.bloock.sdk.entity.identity.IntegerEnumAttributeDescriptor;
import com.bloock.sdk.entity.identity.Schema;
import com.bloock.sdk.entity.identity.StringAttributeDescriptor;
import com.bloock.sdk.entity.identity.StringEnumAttributeDescriptor;
import java.util.ArrayList;
import java.util.List;

public class SchemaBuilder {
    private final String displayName;
    private final String schemaType;
    private final String version;
    private final String description;
    private final BloockConfig.ConfigData configData;
    private final List<BloockIdentityEntities.StringAttributeDefinition> stringAttributes;
    private final List<BloockIdentityEntities.IntegerAttributeDefinition> integerAttributes;
    private final List<BloockIdentityEntities.DecimalAttributeDefinition> decimalAttributes;
    private final List<BloockIdentityEntities.BooleanAttributeDefinition> booleanAttributes;
    private final List<BloockIdentityEntities.DateAttributeDefinition> dateAttributes;
    private final List<BloockIdentityEntities.DateTimeAttributeDefinition> datetimeAttributes;
    private final List<BloockIdentityEntities.StringEnumAttributeDefinition> stringEnumAttributes;
    private final List<BloockIdentityEntities.IntegerEnumAttributeDefinition> integerEnumAttributes;
    private final List<BloockIdentityEntities.DecimalEnumAttributeDefinition> decimalEnumAttributes;

    public SchemaBuilder(String displayName, String schemaType, String version, String description, BloockConfig.ConfigData configData) {
        this.displayName = displayName;
        this.schemaType = schemaType;
        this.version = version;
        this.description = description;
        this.configData = configData;
        this.stringAttributes = new ArrayList<BloockIdentityEntities.StringAttributeDefinition>();
        this.integerAttributes = new ArrayList<BloockIdentityEntities.IntegerAttributeDefinition>();
        this.decimalAttributes = new ArrayList<BloockIdentityEntities.DecimalAttributeDefinition>();
        this.booleanAttributes = new ArrayList<BloockIdentityEntities.BooleanAttributeDefinition>();
        this.dateAttributes = new ArrayList<BloockIdentityEntities.DateAttributeDefinition>();
        this.datetimeAttributes = new ArrayList<BloockIdentityEntities.DateTimeAttributeDefinition>();
        this.stringEnumAttributes = new ArrayList<BloockIdentityEntities.StringEnumAttributeDefinition>();
        this.integerEnumAttributes = new ArrayList<BloockIdentityEntities.IntegerEnumAttributeDefinition>();
        this.decimalEnumAttributes = new ArrayList<BloockIdentityEntities.DecimalEnumAttributeDefinition>();
    }

    public SchemaBuilder addStringAttribute(String name, String technicalName, String description, Boolean required) {
        this.stringAttributes.add(new StringAttributeDescriptor(name, technicalName, description, required).toProto());
        return this;
    }

    public SchemaBuilder addIntegerAttribute(String name, String technicalName, String description, Boolean required) {
        this.integerAttributes.add(new IntegerAttributeDescriptor(name, technicalName, description, required).toProto());
        return this;
    }

    public SchemaBuilder addDecimalAttribute(String name, String technicalName, String description, Boolean required) {
        this.decimalAttributes.add(new DecimalAttributeDescriptor(name, technicalName, description, required).toProto());
        return this;
    }

    public SchemaBuilder addBooleanAttribute(String name, String technicalName, String description, Boolean required) {
        this.booleanAttributes.add(new BooleanAttributeDescriptor(name, technicalName, description, required).toProto());
        return this;
    }

    public SchemaBuilder addDateAttribute(String name, String technicalName, String description, Boolean required) {
        this.dateAttributes.add(new DateAttributeDescriptor(name, technicalName, description, required).toProto());
        return this;
    }

    public SchemaBuilder addDatetimeAttribute(String name, String technicalName, String description, Boolean required) {
        this.datetimeAttributes.add(new DatetimeAttributeDescriptor(name, technicalName, description, required).toProto());
        return this;
    }

    public SchemaBuilder addStringEnumAttribute(String name, String technicalName, String description, Boolean required, List<String> enumeration) {
        this.stringEnumAttributes.add(new StringEnumAttributeDescriptor(name, technicalName, description, required, enumeration).toProto());
        return this;
    }

    public SchemaBuilder addIntegerEnumAttribute(String name, String technicalName, String description, Boolean required, List<Long> enumeration) {
        this.integerEnumAttributes.add(new IntegerEnumAttributeDescriptor(name, technicalName, description, required, enumeration).toProto());
        return this;
    }

    public SchemaBuilder addDecimalEnumAttribute(String name, String technicalName, String description, Boolean required, List<Double> enumeration) {
        this.decimalEnumAttributes.add(new DecimalEnumAttributeDescriptor(name, technicalName, description, required, enumeration).toProto());
        return this;
    }

    public Schema build() throws Exception {
        Bridge bridge = new Bridge();
        BloockIdentity.BuildSchemaRequest req = BloockIdentity.BuildSchemaRequest.newBuilder().setConfigData(this.configData).setDisplayName(this.displayName).setSchemaType(this.schemaType).setVersion(this.version).setDescription(this.description).addAllStringAttributes(this.stringAttributes).addAllIntegerAttributes(this.integerAttributes).addAllDecimalAttributes(this.decimalAttributes).addAllBooleanAttributes(this.booleanAttributes).addAllDateAttributes(this.dateAttributes).addAllDatetimeAttributes(this.datetimeAttributes).addAllStringEnumAttributes(this.stringEnumAttributes).addAllIntegerEnumAttributes(this.integerEnumAttributes).addAllDecimalEnumAttributes(this.decimalEnumAttributes).build();
        BloockIdentity.BuildSchemaResponse response = bridge.getIdentity().buildSchema(req);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return Schema.fromProto(response.getSchema());
    }
}

