/*
 * Decompiled with CFR 0.152.
 */
package com.bloock.sdk.entity.integrity;

import com.bloock.sdk.bridge.proto.BloockIntegrityEntities;
import com.bloock.sdk.entity.integrity.AnchorNetwork;
import java.util.List;
import java.util.stream.Collectors;

public class Anchor {
    long id;
    List<String> blockRoots;
    List<AnchorNetwork> networks;
    String root;
    String status;

    Anchor(long id, List<String> blockRoots, List<AnchorNetwork> networks, String root, String status) {
        this.id = id;
        this.blockRoots = blockRoots;
        this.networks = networks;
        this.root = root;
        this.status = status;
    }

    public static Anchor fromProto(BloockIntegrityEntities.Anchor anchor) {
        return new Anchor(anchor.getId(), (List<String>)anchor.getBlockRootsList(), anchor.getNetworksList().stream().map(AnchorNetwork::fromProto).collect(Collectors.toList()), anchor.getRoot(), anchor.getStatus());
    }

    BloockIntegrityEntities.Anchor toProto() {
        return BloockIntegrityEntities.Anchor.newBuilder().setId(this.id).addAllBlockRoots(this.blockRoots).addAllNetworks(this.networks.stream().map(AnchorNetwork::toProto).collect(Collectors.toList())).build();
    }

    public String toString() {
        return "{id: " + this.id + ", blockRoots: " + this.blockRoots + ", root: " + this.root + ", status: " + this.status + ", networks: " + this.networks + "}";
    }

    public long getId() {
        return this.id;
    }

    public List<String> getBlockRoots() {
        return this.blockRoots;
    }

    public List<AnchorNetwork> getNetworks() {
        return this.networks;
    }

    public String getRoot() {
        return this.root;
    }

    public String getStatus() {
        return this.status;
    }
}

