/*
 * Decompiled with CFR 0.152.
 */
package com.bloock.sdk.entity.integrity;

import com.bloock.sdk.bridge.proto.BloockIntegrityEntities;
import com.bloock.sdk.entity.integrity.ProofAnchor;
import java.util.List;

public class Proof {
    List<String> leaves;
    List<String> nodes;
    String depth;
    String bitmap;
    ProofAnchor anchor;

    public Proof(List<String> leaves, List<String> nodes, String depth, String bitmap, ProofAnchor anchor) {
        this.leaves = leaves;
        this.nodes = nodes;
        this.depth = depth;
        this.bitmap = bitmap;
        this.anchor = anchor;
    }

    public static Proof fromProto(BloockIntegrityEntities.Proof proof) {
        return new Proof((List<String>)proof.getLeavesList(), (List<String>)proof.getNodesList(), proof.getDepth(), proof.getBitmap(), ProofAnchor.fromProto(proof.getAnchor()));
    }

    public BloockIntegrityEntities.Proof toProto() {
        return BloockIntegrityEntities.Proof.newBuilder().addAllLeaves(this.leaves).addAllNodes(this.nodes).setDepth(this.depth).setBitmap(this.bitmap).setAnchor(this.anchor.toProto()).build();
    }

    public List<String> getLeaves() {
        return this.leaves;
    }

    public List<String> getNodes() {
        return this.nodes;
    }

    public String getDepth() {
        return this.depth;
    }

    public String getBitmap() {
        return this.bitmap;
    }

    public ProofAnchor getAnchor() {
        return this.anchor;
    }
}

