/*
 * Decompiled with CFR 0.152.
 */
package com.bloock.sdk.entity.integrity;

import com.bloock.sdk.bridge.proto.BloockIntegrityEntities;
import com.bloock.sdk.entity.integrity.AnchorNetwork;
import java.util.List;
import java.util.stream.Collectors;

public class ProofAnchor {
    long anchorId;
    List<AnchorNetwork> networks;
    String root;
    String status;

    public ProofAnchor(long anchorId, List<AnchorNetwork> networks, String root, String status) {
        this.anchorId = anchorId;
        this.networks = networks;
        this.root = root;
        this.status = status;
    }

    public static ProofAnchor fromProto(BloockIntegrityEntities.ProofAnchor anchor) {
        return new ProofAnchor(anchor.getAnchorId(), anchor.getNetworksList().stream().map(x -> AnchorNetwork.fromProto(x)).collect(Collectors.toList()), anchor.getRoot(), anchor.getStatus());
    }

    BloockIntegrityEntities.ProofAnchor toProto() {
        return BloockIntegrityEntities.ProofAnchor.newBuilder().setAnchorId(this.anchorId).addAllNetworks(this.networks.stream().map(x -> x.toProto()).collect(Collectors.toList())).setRoot(this.root).setStatus(this.status).build();
    }

    public long getAnchorId() {
        return this.anchorId;
    }

    public List<AnchorNetwork> getNetworks() {
        return this.networks;
    }

    public String getRoot() {
        return this.root;
    }

    public String getStatus() {
        return this.status;
    }
}

