/*
 * Decompiled with CFR 0.152.
 */
package com.bloock.sdk.entity.key;

import com.bloock.sdk.bridge.proto.BloockKeysEntities;
import com.google.protobuf.ByteString;

public class LocalCertificate {
    byte[] pkcs12;
    String password;

    public LocalCertificate(byte[] pkcs12, String password) {
        this.pkcs12 = pkcs12;
        this.password = password;
    }

    public static LocalCertificate fromProto(BloockKeysEntities.LocalCertificate certificate) {
        return new LocalCertificate(certificate.getPkcs12().toByteArray(), certificate.getPassword());
    }

    public BloockKeysEntities.LocalCertificate toProto() {
        BloockKeysEntities.LocalCertificate.Builder builder = BloockKeysEntities.LocalCertificate.newBuilder();
        if (this.pkcs12 != null) {
            builder.setPkcs12(ByteString.copyFrom((byte[])this.pkcs12));
        }
        if (this.password != null) {
            builder.setPassword(this.password);
        }
        return builder.build();
    }

    public byte[] getPkcs12() {
        return this.pkcs12;
    }

    public String getPassword() {
        return this.password;
    }
}

