/*
 * Decompiled with CFR 0.152.
 */
package com.bloock.sdk.entity.key;

import com.bloock.sdk.bridge.proto.BloockKeysEntities;
import com.bloock.sdk.entity.key.AccessControlType;
import com.bloock.sdk.entity.key.KeyProtectionLevel;
import com.bloock.sdk.entity.key.KeyType;

public class ManagedCertificate {
    String id;
    KeyProtectionLevel protection;
    KeyType keyType;
    long expiration;
    String key;
    AccessControlType accessControlType;

    public ManagedCertificate(String id, KeyProtectionLevel protection, KeyType keyType, long expiration, String key, AccessControlType accessControlType) {
        this.id = id;
        this.protection = protection;
        this.keyType = keyType;
        this.expiration = expiration;
        this.key = key;
        this.accessControlType = accessControlType;
    }

    public static ManagedCertificate fromProto(BloockKeysEntities.ManagedCertificate certificate) {
        return new ManagedCertificate(certificate.getId(), KeyProtectionLevel.fromProto(certificate.getProtection()), KeyType.fromProto(certificate.getKeyType()), certificate.getExpiration(), certificate.getKey(), AccessControlType.fromProto(certificate.getAccessControlType()));
    }

    public BloockKeysEntities.ManagedCertificate toProto() {
        return BloockKeysEntities.ManagedCertificate.newBuilder().setId(this.id).setProtection(this.protection.toProto()).setKeyType(this.keyType.toProto()).setExpiration(this.expiration).setKey(this.key).setAccessControlType(this.accessControlType.toProto()).build();
    }

    public String getId() {
        return this.id;
    }

    public KeyProtectionLevel getProtection() {
        return this.protection;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public String getKey() {
        return this.key;
    }

    public AccessControlType getAccessControlType() {
        return this.accessControlType;
    }
}

