/*
 * Decompiled with CFR 0.152.
 */
package com.bloock.sdk.entity.key;

import com.bloock.sdk.bridge.proto.BloockKeysEntities;
import com.bloock.sdk.entity.key.KeyType;
import com.bloock.sdk.entity.key.SubjectCertificateParams;

public class ManagedCertificateParams {
    KeyType keyType;
    SubjectCertificateParams subject;
    int expiration;

    public ManagedCertificateParams(KeyType keyType, SubjectCertificateParams subject, int expirationMonths) {
        this.keyType = keyType;
        this.subject = subject;
        this.expiration = expirationMonths;
    }

    public static ManagedCertificateParams fromProto(BloockKeysEntities.ManagedCertificateParams params) {
        return new ManagedCertificateParams(KeyType.fromProto(params.getKeyType()), new SubjectCertificateParams(params.getSubject().getCommonName(), params.getSubject().getOrganization(), params.getSubject().getOrganizationalUnit(), params.getSubject().getLocation(), params.getSubject().getState(), params.getSubject().getCountry()), params.getExpiration());
    }

    public BloockKeysEntities.ManagedCertificateParams toProto() {
        BloockKeysEntities.ManagedCertificateParams.Builder params = BloockKeysEntities.ManagedCertificateParams.newBuilder().setKeyType(this.keyType.toProto()).setSubject(this.subject.toProto()).setExpiration(this.expiration);
        return params.build();
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public SubjectCertificateParams getSubject() {
        return this.subject;
    }

    public int getExpiration() {
        return this.expiration;
    }
}

