/*
 * Decompiled with CFR 0.152.
 */
package com.bloock.sdk.entity.record;

import com.bloock.sdk.bridge.Bridge;
import com.bloock.sdk.bridge.proto.BloockConfig;
import com.bloock.sdk.bridge.proto.BloockRecord;
import com.bloock.sdk.bridge.proto.BloockRecordEntities;
import com.bloock.sdk.bridge.proto.BloockShared;
import com.bloock.sdk.entity.integrity.Proof;
import com.google.protobuf.ByteString;

public class Record {
    byte[] payload;
    String hash;
    BloockConfig.ConfigData configData;

    Record(byte[] payload, String hash, BloockConfig.ConfigData configData) {
        this.payload = payload;
        this.hash = hash;
        this.configData = configData;
    }

    public static Record fromProto(BloockRecordEntities.Record record, BloockConfig.ConfigData configData) {
        return new Record(record.getPayload().toByteArray(), record.getHash(), configData);
    }

    public BloockRecordEntities.Record toProto() {
        return BloockRecordEntities.Record.newBuilder().setConfigData(this.configData).setPayload(ByteString.copyFrom((byte[])this.payload)).setHash(this.hash).build();
    }

    public String getHash() throws Exception {
        Bridge bridge = new Bridge();
        BloockRecord.GetHashRequest request = BloockRecord.GetHashRequest.newBuilder().setConfigData(this.configData).setRecord(this.toProto()).build();
        BloockRecord.GetHashResponse recordHash = bridge.getRecord().getHash(request);
        if (recordHash.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(recordHash.getError().getMessage());
        }
        return recordHash.getHash();
    }

    public byte[] getPayload() throws Exception {
        Bridge bridge = new Bridge();
        BloockRecord.GetPayloadRequest request = BloockRecord.GetPayloadRequest.newBuilder().setConfigData(this.configData).setRecord(this.toProto()).build();
        BloockRecord.GetPayloadResponse res = bridge.getRecord().getPayload(request);
        if (res.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(res.getError().getMessage());
        }
        return res.getPayload().toByteArray();
    }

    public byte[] retrieve() {
        return this.payload;
    }

    public void setProof(Proof proof) throws Exception {
        Bridge bridge = new Bridge();
        BloockRecord.SetProofRequest request = BloockRecord.SetProofRequest.newBuilder().setProof(proof.toProto()).setRecord(this.toProto()).setConfigData(this.configData).build();
        BloockRecord.SetProofResponse response = bridge.getRecord().setProof(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        this.payload = response.getRecord().getPayload().toByteArray();
    }
}

