/*
 * Decompiled with CFR 0.152.
 */
package com.bloock.sdk.entity.record;

import com.bloock.sdk.bridge.proto.BloockRecordEntities;
import com.bloock.sdk.entity.record.AuthenticityDetails;
import com.bloock.sdk.entity.record.AvailabilityDetails;
import com.bloock.sdk.entity.record.EncryptionDetails;
import com.bloock.sdk.entity.record.IntegrityDetails;

public class RecordDetails {
    IntegrityDetails integrity;
    AuthenticityDetails authenticity;
    EncryptionDetails encryption;
    AvailabilityDetails availability;

    RecordDetails(IntegrityDetails integrity, AuthenticityDetails authenticity, EncryptionDetails encryption, AvailabilityDetails availability) {
        this.integrity = integrity;
        this.authenticity = authenticity;
        this.encryption = encryption;
        this.availability = availability;
    }

    public IntegrityDetails getIntegrity() {
        return this.integrity;
    }

    public AuthenticityDetails getAuthenticity() {
        return this.authenticity;
    }

    public EncryptionDetails getEncryption() {
        return this.encryption;
    }

    public AvailabilityDetails getAvailability() {
        return this.availability;
    }

    public static RecordDetails fromProto(BloockRecordEntities.RecordDetails details) {
        IntegrityDetails integrityDetails = null;
        if (details.hasIntegrity()) {
            integrityDetails = IntegrityDetails.fromProto(details.getIntegrity());
        }
        AuthenticityDetails authenticityDetails = null;
        if (details.hasAuthenticity()) {
            authenticityDetails = AuthenticityDetails.fromProto(details.getAuthenticity());
        }
        EncryptionDetails encryptionDetails = null;
        if (details.hasEncryption()) {
            encryptionDetails = EncryptionDetails.fromProto(details.getEncryption());
        }
        AvailabilityDetails availabilityDetails = null;
        if (details.hasAvailability()) {
            availabilityDetails = AvailabilityDetails.fromProto(details.getAvailability());
        }
        return new RecordDetails(integrityDetails, authenticityDetails, encryptionDetails, availabilityDetails);
    }

    public BloockRecordEntities.RecordDetails toProto() {
        return BloockRecordEntities.RecordDetails.newBuilder().setIntegrity(this.integrity.toProto()).setAuthenticity(this.authenticity.toProto()).setEncryption(this.encryption.toProto()).setAvailability(this.availability.toProto()).build();
    }
}

