/*
 * Decompiled with CFR 0.152.
 */
package com.blossomproject.core.validation;

import com.blossomproject.core.validation.FieldMatch;
import java.lang.reflect.Field;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class FieldMatchValidator
implements ConstraintValidator<FieldMatch, Object> {
    private String value;
    private String confirmation;

    public void initialize(FieldMatch constraintAnnotation) {
        this.value = constraintAnnotation.value();
        this.confirmation = constraintAnnotation.confirmation();
    }

    public boolean isValid(Object target, ConstraintValidatorContext context) {
        try {
            String valueValue = this.extractField(target, this.value);
            String confirmationValue = this.extractField(target, this.confirmation);
            return valueValue == null && confirmationValue == null || valueValue != null && valueValue.equals(confirmationValue);
        }
        catch (Exception exception) {
            return true;
        }
    }

    private String extractField(Object target, String fieldValue) throws NoSuchFieldException, IllegalAccessException {
        Field field = target.getClass().getDeclaredField(fieldValue);
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        String str = (String)field.get(target);
        field.setAccessible(accessible);
        return str;
    }
}

