/*
 * Decompiled with CFR 0.152.
 */
package com.blossomproject.core.validation;

import com.blossomproject.core.validation.BeanValidationConstraints;
import com.blossomproject.core.validation.ValidationRegistry;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationRegistryImpl
implements ValidationRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ValidationRegistryImpl.class);
    private Map<Class<?>, BeanValidationConstraints> constraints = new ConcurrentHashMap();

    @Override
    public BeanValidationConstraints getContraintsFor(Class<?> clazz) {
        if (!this.hasContraintsFor(clazz)) {
            throw new RuntimeException("No contraints found for clazz " + clazz);
        }
        return this.constraints.get(clazz);
    }

    @Override
    public boolean hasContraintsFor(Class<?> delimiter) {
        return this.constraints.containsKey(delimiter);
    }

    @Override
    public Collection<BeanValidationConstraints> getContraints() {
        return this.constraints.values();
    }

    @Override
    public void addContraints(Class<?> clazz, BeanValidationConstraints constraints) {
        if (logger.isWarnEnabled() && this.constraints.containsKey(clazz)) {
            logger.warn("Overriding contraints for class {}", clazz);
        }
        this.constraints.put(clazz, constraints);
    }
}

