/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.aiken;

import com.bloxbean.cardano.aiken.exception.ApplyParamException;
import com.bloxbean.cardano.aiken.jna.CardanoJNAUtil;
import com.bloxbean.cardano.client.plutus.spec.ListPlutusData;
import com.bloxbean.cardano.client.util.JsonUtil;
import com.fasterxml.jackson.databind.JsonNode;

public class AikenScriptUtil {
    public static String applyParamToScript(ListPlutusData params, String compiledCode) {
        try {
            String json = CardanoJNAUtil.apply_params_to_plutus_script(params.serializeToHex(), compiledCode);
            JsonNode node = JsonUtil.parseJson((String)json);
            String status = node.get("status").asText();
            if (status.equalsIgnoreCase("SUCCESS")) {
                return node.get("compiled_code").asText();
            }
            throw new ApplyParamException(node.get("error").asText());
        }
        catch (ApplyParamException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ApplyParamException("Error applying param to script", e);
        }
    }
}

