/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.aiken;

import com.bloxbean.cardano.aiken.tx.evaluator.SlotConfig;
import com.bloxbean.cardano.aiken.tx.evaluator.TxEvaluator;
import com.bloxbean.cardano.client.api.ProtocolParamsSupplier;
import com.bloxbean.cardano.client.api.ScriptSupplier;
import com.bloxbean.cardano.client.api.TransactionEvaluator;
import com.bloxbean.cardano.client.api.UtxoSupplier;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.EvaluationResult;
import com.bloxbean.cardano.client.api.model.ProtocolParams;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.api.util.CostModelUtil;
import com.bloxbean.cardano.client.backend.api.BackendService;
import com.bloxbean.cardano.client.backend.api.DefaultProtocolParamsSupplier;
import com.bloxbean.cardano.client.backend.api.DefaultUtxoSupplier;
import com.bloxbean.cardano.client.common.model.SlotConfigs;
import com.bloxbean.cardano.client.plutus.spec.CostMdls;
import com.bloxbean.cardano.client.plutus.spec.CostModel;
import com.bloxbean.cardano.client.plutus.spec.Language;
import com.bloxbean.cardano.client.plutus.spec.PlutusScript;
import com.bloxbean.cardano.client.plutus.spec.Redeemer;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.transaction.spec.TransactionWitnessSet;
import com.bloxbean.cardano.client.util.JsonUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;

public class AikenTransactionEvaluator
implements TransactionEvaluator {
    private UtxoSupplier utxoSupplier;
    private ProtocolParamsSupplier protocolParamsSupplier;
    private ScriptSupplier scriptSupplier;
    private final com.bloxbean.cardano.client.common.model.SlotConfig slotConfig;

    public AikenTransactionEvaluator(@NonNull BackendService backendService) {
        this(backendService, SlotConfigs.mainnet());
        if (backendService == null) {
            throw new NullPointerException("backendService is marked non-null but is null");
        }
    }

    public AikenTransactionEvaluator(@NonNull BackendService backendService, com.bloxbean.cardano.client.common.model.SlotConfig slotConfig) {
        if (backendService == null) {
            throw new NullPointerException("backendService is marked non-null but is null");
        }
        this.utxoSupplier = new DefaultUtxoSupplier(backendService.getUtxoService());
        this.protocolParamsSupplier = new DefaultProtocolParamsSupplier(backendService.getEpochService());
        this.slotConfig = slotConfig;
    }

    public AikenTransactionEvaluator(@NonNull BackendService backendService, ScriptSupplier scriptSupplier) {
        if (backendService == null) {
            throw new NullPointerException("backendService is marked non-null but is null");
        }
        this.utxoSupplier = new DefaultUtxoSupplier(backendService.getUtxoService());
        this.protocolParamsSupplier = new DefaultProtocolParamsSupplier(backendService.getEpochService());
        this.scriptSupplier = scriptSupplier;
        this.slotConfig = SlotConfigs.mainnet();
    }

    public AikenTransactionEvaluator(@NonNull UtxoSupplier utxoSupplier, @NonNull ProtocolParamsSupplier protocolParamsSupplier) {
        if (utxoSupplier == null) {
            throw new NullPointerException("utxoSupplier is marked non-null but is null");
        }
        if (protocolParamsSupplier == null) {
            throw new NullPointerException("protocolParamsSupplier is marked non-null but is null");
        }
        this.utxoSupplier = utxoSupplier;
        this.protocolParamsSupplier = protocolParamsSupplier;
        this.slotConfig = SlotConfigs.mainnet();
    }

    public AikenTransactionEvaluator(@NonNull UtxoSupplier utxoSupplier, @NonNull ProtocolParamsSupplier protocolParamsSupplier, ScriptSupplier scriptSupplier) {
        this(utxoSupplier, protocolParamsSupplier, scriptSupplier, SlotConfigs.mainnet());
        if (utxoSupplier == null) {
            throw new NullPointerException("utxoSupplier is marked non-null but is null");
        }
        if (protocolParamsSupplier == null) {
            throw new NullPointerException("protocolParamsSupplier is marked non-null but is null");
        }
    }

    public AikenTransactionEvaluator(@NonNull UtxoSupplier utxoSupplier, @NonNull ProtocolParamsSupplier protocolParamsSupplier, ScriptSupplier scriptSupplier, com.bloxbean.cardano.client.common.model.SlotConfig slotConfig) {
        if (utxoSupplier == null) {
            throw new NullPointerException("utxoSupplier is marked non-null but is null");
        }
        if (protocolParamsSupplier == null) {
            throw new NullPointerException("protocolParamsSupplier is marked non-null but is null");
        }
        this.utxoSupplier = utxoSupplier;
        this.protocolParamsSupplier = protocolParamsSupplier;
        this.scriptSupplier = scriptSupplier;
        this.slotConfig = slotConfig;
    }

    public Result<List<EvaluationResult>> evaluateTx(byte[] cbor, Set<Utxo> inputUtxos) throws ApiException {
        try {
            Transaction transaction = Transaction.deserialize((byte[])cbor);
            HashSet<Utxo> utxos = new HashSet<Utxo>();
            for (Object input : transaction.getBody().getInputs()) {
                Utxo utxo = (Utxo)this.utxoSupplier.getTxOutput(input.getTransactionId(), input.getIndex()).get();
                utxos.add(utxo);
            }
            ArrayList<PlutusScript> additionalScripts = new ArrayList<PlutusScript>();
            for (Object input : transaction.getBody().getReferenceInputs()) {
                Utxo utxo = (Utxo)this.utxoSupplier.getTxOutput(input.getTransactionId(), input.getIndex()).get();
                utxos.add(utxo);
                if (utxo.getReferenceScriptHash() == null || this.scriptSupplier == null) continue;
                this.scriptSupplier.getScript(utxo.getReferenceScriptHash()).ifPresent(additionalScripts::add);
            }
            if (transaction.getWitnessSet() == null) {
                transaction.setWitnessSet(new TransactionWitnessSet());
            }
            if (transaction.getWitnessSet().getPlutusV1Scripts() == null) {
                transaction.getWitnessSet().setPlutusV1Scripts(new ArrayList());
            }
            if (transaction.getWitnessSet().getPlutusV2Scripts() == null) {
                transaction.getWitnessSet().setPlutusV2Scripts(new ArrayList());
            }
            HashSet<Language> languages = new HashSet<Language>();
            if (transaction.getWitnessSet() != null && transaction.getWitnessSet().getPlutusV1Scripts() != null && transaction.getWitnessSet().getPlutusV1Scripts().size() > 0) {
                languages.add(Language.PLUTUS_V1);
            }
            if (transaction.getWitnessSet() != null && transaction.getWitnessSet().getPlutusV2Scripts() != null && transaction.getWitnessSet().getPlutusV2Scripts().size() > 0) {
                languages.add(Language.PLUTUS_V2);
            }
            if (transaction.getWitnessSet() != null && transaction.getWitnessSet().getPlutusV3Scripts() != null && transaction.getWitnessSet().getPlutusV3Scripts().size() > 0) {
                languages.add(Language.PLUTUS_V3);
            }
            for (PlutusScript script : additionalScripts) {
                if (script == null) continue;
                if (script.getLanguage() == Language.PLUTUS_V1) {
                    languages.add(Language.PLUTUS_V1);
                    continue;
                }
                if (script.getLanguage() == Language.PLUTUS_V2) {
                    languages.add(Language.PLUTUS_V2);
                    continue;
                }
                if (script.getLanguage() == Language.PLUTUS_V3) {
                    languages.add(Language.PLUTUS_V3);
                    continue;
                }
                throw new ApiException("Unsupported language: " + script.getLanguage());
            }
            ProtocolParams protocolParams = this.protocolParamsSupplier.getProtocolParams();
            CostMdls costMdls = new CostMdls();
            languages.stream().map(language -> CostModelUtil.getCostModelFromProtocolParams((ProtocolParams)protocolParams, (Language)language)).filter(Optional::isPresent).forEach(costModelOptional -> costMdls.add((CostModel)costModelOptional.get()));
            TxEvaluator txEvaluator = new TxEvaluator(this.getSlotConfig());
            List<Redeemer> redeemers = txEvaluator.evaluateTx(transaction, utxos, additionalScripts, costMdls);
            if (redeemers == null) {
                return Result.success((String)"Error evaluating transaction");
            }
            List evaluationResults = redeemers.stream().map(redeemer -> EvaluationResult.builder().redeemerTag(redeemer.getTag()).index(redeemer.getIndex().intValue()).exUnits(redeemer.getExUnits()).build()).collect(Collectors.toList());
            return Result.success((String)JsonUtil.getPrettyJson(evaluationResults)).withValue(evaluationResults);
        }
        catch (Exception e) {
            throw new ApiException("Error evaluating transaction", e);
        }
    }

    private SlotConfig getSlotConfig() {
        SlotConfig.SlotConfigByReference slotConfig = new SlotConfig.SlotConfigByReference();
        slotConfig.zero_time = this.slotConfig.getZeroTime();
        slotConfig.zero_slot = this.slotConfig.getZeroSlot();
        slotConfig.slot_length = this.slotConfig.getSlotLength();
        return slotConfig;
    }
}

