/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.aiken.tx.evaluator;

import co.nstant.in.cbor.model.DataItem;
import com.bloxbean.cardano.aiken.jna.CardanoJNAUtil;
import com.bloxbean.cardano.aiken.tx.evaluator.AikenCbors;
import com.bloxbean.cardano.aiken.tx.evaluator.InitialBudgetConfig;
import com.bloxbean.cardano.aiken.tx.evaluator.SlotConfig;
import com.bloxbean.cardano.aiken.tx.evaluator.exception.TxEvaluationException;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.plutus.spec.CostMdls;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.bloxbean.cardano.client.plutus.spec.PlutusScript;
import com.bloxbean.cardano.client.plutus.spec.Redeemer;
import com.bloxbean.cardano.client.spec.Script;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.transaction.spec.TransactionInput;
import com.bloxbean.cardano.client.transaction.spec.TransactionOutput;
import com.bloxbean.cardano.client.util.HexUtil;
import com.bloxbean.cardano.client.util.JsonUtil;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxEvaluator {
    private static final Logger log = LoggerFactory.getLogger(TxEvaluator.class);
    private final SlotConfig.SlotConfigByReference slotConfig;
    private final InitialBudgetConfig.InitialBudgetByValue initialBudgetConfig;

    public TxEvaluator() {
        this.slotConfig = TxEvaluator.getDefaultSlotConfig();
        this.initialBudgetConfig = TxEvaluator.getDefaultInitialBudgetConfig();
    }

    public TxEvaluator(InitialBudgetConfig initialBudgetConfig) {
        this.slotConfig = TxEvaluator.getDefaultSlotConfig();
        this.initialBudgetConfig = new InitialBudgetConfig.InitialBudgetByValue();
        this.initialBudgetConfig.mem = initialBudgetConfig.mem;
        this.initialBudgetConfig.cpu = initialBudgetConfig.cpu;
    }

    public TxEvaluator(SlotConfig slotConfig) {
        this.slotConfig = new SlotConfig.SlotConfigByReference();
        this.slotConfig.zero_slot = slotConfig.zero_slot;
        this.slotConfig.zero_time = slotConfig.zero_time;
        this.slotConfig.slot_length = slotConfig.slot_length;
        this.initialBudgetConfig = TxEvaluator.getDefaultInitialBudgetConfig();
    }

    public TxEvaluator(SlotConfig slotConfig, InitialBudgetConfig initialBudgetConfig) {
        this.slotConfig = new SlotConfig.SlotConfigByReference();
        this.slotConfig.zero_slot = slotConfig.zero_slot;
        this.slotConfig.zero_time = slotConfig.zero_time;
        this.slotConfig.slot_length = slotConfig.slot_length;
        this.initialBudgetConfig = new InitialBudgetConfig.InitialBudgetByValue();
        this.initialBudgetConfig.mem = initialBudgetConfig.mem;
        this.initialBudgetConfig.cpu = initialBudgetConfig.cpu;
    }

    public List<Redeemer> evaluateTx(Transaction transaction, Set<Utxo> inputUtxos, CostMdls costMdls) {
        return this.evaluateTx(transaction, inputUtxos, Collections.emptyList(), costMdls);
    }

    public List<Redeemer> evaluateTx(Transaction transaction, Set<Utxo> inputUtxos, List<PlutusScript> scripts, CostMdls costMdls) {
        ArrayList<PlutusScript> witnessScripts = new ArrayList<PlutusScript>();
        witnessScripts.addAll(transaction.getWitnessSet().getPlutusV1Scripts());
        witnessScripts.addAll(transaction.getWitnessSet().getPlutusV2Scripts());
        ArrayList<PlutusScript> allScripts = scripts != null ? Stream.concat(scripts.stream(), witnessScripts.stream()).collect(Collectors.toList()) : witnessScripts;
        List txInputs = transaction.getBody().getInputs();
        List refTxInputs = transaction.getBody().getReferenceInputs();
        List<TransactionInput> allInputs = Stream.concat(txInputs.stream(), refTxInputs.stream()).collect(Collectors.toList());
        List<TransactionOutput> txOutputs = this.resolveTxInputs(allInputs, inputUtxos, allScripts);
        try {
            JsonNode node;
            String status;
            String costMdlsHex = HexUtil.encodeHexString((byte[])CborSerializationUtil.serialize((DataItem)costMdls.serialize()));
            String trxCbor = transaction.serializeToHex();
            String inputsCbor = HexUtil.encodeHexString((byte[])CborSerializationUtil.serialize((DataItem)AikenCbors.serialiseInputs(allInputs)));
            String outputsCbor = HexUtil.encodeHexString((byte[])CborSerializationUtil.serialize((DataItem)AikenCbors.serialiseOutputs(txOutputs)));
            String json = CardanoJNAUtil.eval_phase_two_raw(trxCbor, inputsCbor, outputsCbor, costMdlsHex, this.initialBudgetConfig, this.slotConfig);
            if (log.isTraceEnabled()) {
                log.trace("Transaction: " + trxCbor);
                log.trace("Inputs : " + inputsCbor);
                log.trace("Outputs : " + outputsCbor);
                log.trace("CostMdlsHex : " + costMdlsHex);
            }
            if ((status = (node = JsonUtil.parseJson((String)json)).get("status").asText()).equalsIgnoreCase("SUCCESS")) {
                return AikenCbors.deserializeRedeemerArray(node.get("redeemer_cbor").asText());
            }
            log.error("TxEvaluation failed. Error: " + node.get("error").asText());
            throw new TxEvaluationException(node.get("error").asText());
        }
        catch (TxEvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TxEvaluationException("TxEvaluation failed", e);
        }
    }

    private static SlotConfig.SlotConfigByReference getDefaultSlotConfig() {
        SlotConfig.SlotConfigByReference slotConfig = new SlotConfig.SlotConfigByReference();
        slotConfig.zero_time = 1660003200000L;
        slotConfig.zero_slot = 0L;
        slotConfig.slot_length = 1000;
        return slotConfig;
    }

    private static InitialBudgetConfig.InitialBudgetByValue getDefaultInitialBudgetConfig() {
        InitialBudgetConfig.InitialBudgetByValue initialBudgetConfig = new InitialBudgetConfig.InitialBudgetByValue();
        initialBudgetConfig.mem = 14000000L;
        initialBudgetConfig.cpu = 10000000000L;
        return initialBudgetConfig;
    }

    private List<TransactionOutput> resolveTxInputs(List<TransactionInput> transactionInputs, Set<Utxo> utxos, List<PlutusScript> plutusScripts) {
        return transactionInputs.stream().map(input -> {
            try {
                Utxo utxo = utxos.stream().filter(_utxo -> input.getTransactionId().equals(_utxo.getTxHash())).filter(_utxo -> input.getIndex() == _utxo.getOutputIndex()).findFirst().orElseThrow();
                String address = utxo.getAddress();
                PlutusScript plutusScript = plutusScripts.stream().filter(script -> {
                    try {
                        return HexUtil.encodeHexString((byte[])script.getScriptHash()).equals(utxo.getReferenceScriptHash());
                    }
                    catch (CborSerializationException e) {
                        throw new IllegalStateException(e);
                    }
                }).findFirst().orElse(null);
                PlutusData inlineDatum = utxo.getInlineDatum() != null ? PlutusData.deserialize((byte[])HexUtil.decodeHexString((String)utxo.getInlineDatum())) : null;
                byte[] datumHash = utxo.getDataHash() != null ? HexUtil.decodeHexString((String)utxo.getDataHash()) : null;
                return TransactionOutput.builder().address(address).value(utxo.toValue()).datumHash((byte[])(inlineDatum == null ? datumHash : null)).inlineDatum(inlineDatum).scriptRef((Script)plutusScript).build();
            }
            catch (CborDeserializationException e) {
                throw new IllegalStateException(e);
            }
        }).collect(Collectors.toList());
    }
}

