/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.address;

import com.bloxbean.cardano.client.address.AddressProvider;
import com.bloxbean.cardano.client.address.AddressType;
import com.bloxbean.cardano.client.address.util.AddressEncoderDecoderUtil;
import com.bloxbean.cardano.client.common.model.Network;
import com.bloxbean.cardano.client.crypto.Bech32;
import com.bloxbean.cardano.client.exception.AddressRuntimeException;
import java.util.Optional;

public class Address {
    private String prefix;
    private byte[] bytes;
    private String address;
    private AddressType addressType;
    private Network network;

    public Address(String prefix, byte[] bytes) {
        this.prefix = prefix;
        this.bytes = bytes;
        this.addressType = AddressEncoderDecoderUtil.readAddressType(this.bytes);
        this.network = AddressEncoderDecoderUtil.readNetworkType(this.bytes);
    }

    public Address(String address) {
        if (address == null || address.isEmpty()) {
            throw new AddressRuntimeException("Address cannot be null or empty");
        }
        this.address = address;
        Bech32.Bech32Data bech32Data = Bech32.decode((String)address);
        this.bytes = bech32Data.data;
        this.prefix = bech32Data.hrp;
        this.addressType = AddressEncoderDecoderUtil.readAddressType(this.bytes);
        this.network = AddressEncoderDecoderUtil.readNetworkType(this.bytes);
    }

    public Address(byte[] addressBytes) {
        if (addressBytes == null) {
            throw new AddressRuntimeException("Address cannot be null or empty");
        }
        this.bytes = addressBytes;
        this.addressType = AddressEncoderDecoderUtil.readAddressType(this.bytes);
        this.network = AddressEncoderDecoderUtil.readNetworkType(this.bytes);
        this.prefix = AddressEncoderDecoderUtil.getPrefixHeader(this.addressType) + AddressEncoderDecoderUtil.getPrefixTail(AddressEncoderDecoderUtil.getNetworkId(this.network));
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String toBech32() {
        if (this.address == null || this.address.isEmpty()) {
            this.address = Bech32.encode((byte[])this.bytes, (String)this.prefix);
        }
        return this.address;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getAddress() {
        return this.toBech32();
    }

    public AddressType getAddressType() {
        return this.addressType;
    }

    public Network getNetwork() {
        return this.network;
    }

    public Optional<byte[]> getDelegationHash() {
        return AddressProvider.getDelegationHash(this);
    }

    public Optional<byte[]> getPaymentKeyHash() {
        return AddressProvider.getPaymentKeyHash(this);
    }

    public boolean isPubKeyHashInPaymentPart() {
        return AddressProvider.isPubKeyHashInPaymentPart(this);
    }

    public boolean isScriptHashInPaymentPart() {
        return AddressProvider.isScriptHashInPaymentPart(this);
    }

    public boolean isStakeKeyHashInDelegationPart() {
        return AddressProvider.isStakeKeyHashInDelegationPart(this);
    }

    public boolean isScriptHashInDelegationPart() {
        return AddressProvider.isScriptHashInDelegationPart(this);
    }
}

