/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.address.util;

import com.bloxbean.cardano.client.address.AddressType;
import com.bloxbean.cardano.client.common.model.Network;
import com.bloxbean.cardano.client.common.model.Networks;
import com.bloxbean.cardano.client.exception.AddressRuntimeException;
import com.bloxbean.cardano.client.spec.NetworkId;

public class AddressEncoderDecoderUtil {
    public static String getPrefixHeader(AddressType addressType) throws AddressRuntimeException {
        String prefixHead;
        switch (addressType) {
            case Base: {
                prefixHead = "addr";
                break;
            }
            case Reward: {
                prefixHead = "stake";
                break;
            }
            case Enterprise: {
                prefixHead = "addr";
                break;
            }
            case Ptr: {
                prefixHead = "addr";
                break;
            }
            default: {
                throw new AddressRuntimeException("Unknown address type");
            }
        }
        return prefixHead;
    }

    public static String getPrefixTail(NetworkId network) {
        String prefixTail;
        switch (network) {
            case TESTNET: {
                prefixTail = "_test";
                break;
            }
            case MAINNET: {
                prefixTail = "";
                break;
            }
            default: {
                throw new AddressRuntimeException("Unknown network type - " + network);
            }
        }
        return prefixTail;
    }

    public static NetworkId getNetworkId(Network networkInfo) {
        NetworkId network;
        if (Networks.mainnet().getNetworkId() == networkInfo.getNetworkId()) {
            network = NetworkId.MAINNET;
        } else if (Networks.testnet().getNetworkId() == networkInfo.getNetworkId()) {
            network = NetworkId.TESTNET;
        } else {
            throw new AddressRuntimeException("Unknown network type - " + networkInfo);
        }
        return network;
    }

    public static byte getAddressHeader(byte headerKind, Network network, AddressType addressType) {
        return (byte)(headerKind | network.getNetworkId() & 0xF);
    }

    public static AddressType readAddressType(byte[] addressBytes) {
        AddressType addressType;
        byte header = addressBytes[0];
        switch ((header & 0xF0) >> 4) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                addressType = AddressType.Base;
                break;
            }
            case 4: 
            case 5: {
                addressType = AddressType.Ptr;
                break;
            }
            case 6: 
            case 7: {
                addressType = AddressType.Enterprise;
                break;
            }
            case 14: 
            case 15: {
                addressType = AddressType.Reward;
                break;
            }
            case 8: {
                addressType = AddressType.Byron;
                break;
            }
            default: {
                throw new AddressRuntimeException("Unknown address type");
            }
        }
        return addressType;
    }

    public static Network readNetworkType(byte[] addressBytes) {
        Network network;
        byte header = addressBytes[0];
        switch (header & 0xF) {
            case 0: {
                network = Networks.testnet();
                break;
            }
            case 1: {
                network = Networks.mainnet();
                break;
            }
            default: {
                throw new AddressRuntimeException("Unknown network type");
            }
        }
        return network;
    }
}

