/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.address;

import com.bloxbean.cardano.client.address.CredentialType;
import com.bloxbean.cardano.client.util.HexUtil;
import java.util.Arrays;

public class Credential {
    private byte[] bytes;
    private CredentialType type;

    private Credential(byte[] bytes, CredentialType type) {
        this.bytes = bytes;
        this.type = type;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public static Credential fromKey(String keyHash) {
        return new Credential(HexUtil.decodeHexString((String)keyHash), CredentialType.Key);
    }

    public static Credential fromKey(byte[] keyHash) {
        return new Credential(keyHash, CredentialType.Key);
    }

    public static Credential fromScript(String scriptHash) {
        return new Credential(HexUtil.decodeHexString((String)scriptHash), CredentialType.Script);
    }

    public static Credential fromScript(byte[] scriptHash) {
        return new Credential(scriptHash, CredentialType.Script);
    }

    public CredentialType getType() {
        return this.type;
    }

    public String toString() {
        return "Credential(bytes=" + Arrays.toString(this.getBytes()) + ", type=" + this.getType() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Credential)) {
            return false;
        }
        Credential other = (Credential)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getBytes(), other.getBytes())) {
            return false;
        }
        CredentialType this$type = this.getType();
        CredentialType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Credential;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getBytes());
        CredentialType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }
}

