/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.address;

import com.bloxbean.cardano.client.address.Address;
import com.bloxbean.cardano.client.address.AddressType;
import com.bloxbean.cardano.client.address.Pointer;
import com.bloxbean.cardano.client.exception.AddressRuntimeException;
import com.bloxbean.cardano.client.util.Tuple;
import java.util.Arrays;

public class PointerAddress
extends Address {
    private Pointer pointer;

    public PointerAddress(String prefix, byte[] bytes) {
        super(prefix, bytes);
        if (this.getAddressType() != AddressType.Ptr) {
            throw new AddressRuntimeException("Invalid address type. Expected Pointer address type");
        }
        this.decodePointer();
    }

    public PointerAddress(String address) {
        super(address);
        if (this.getAddressType() != AddressType.Ptr) {
            throw new AddressRuntimeException("Invalid address type. Expected Pointer address type");
        }
        this.decodePointer();
    }

    public PointerAddress(byte[] addressBytes) {
        super(addressBytes);
        if (this.getAddressType() != AddressType.Ptr) {
            throw new AddressRuntimeException("Invalid address type. Expected Pointer address type");
        }
        this.decodePointer();
    }

    private void decodePointer() {
        byte[] pointerBytes = this.getDelegationCredentialHash().orElseThrow(() -> new AddressRuntimeException("Delegation credential hash not found"));
        int index = 0;
        Tuple<Long, Integer> slot = this.variableNatDecode(pointerBytes);
        Tuple<Long, Integer> txIndex = this.variableNatDecode(this.getSubBytes(pointerBytes, index += ((Integer)slot._2).intValue()));
        Tuple<Long, Integer> certIndex = this.variableNatDecode(this.getSubBytes(pointerBytes, index += ((Integer)txIndex._2).intValue()));
        this.pointer = new Pointer((Long)slot._1, ((Long)txIndex._1).intValue(), ((Long)certIndex._1).intValue());
    }

    private Tuple<Long, Integer> variableNatDecode(byte[] raw) {
        long output = 0L;
        int bytesRead = 0;
        for (byte rbyte : raw) {
            output = output << 7 | (long)(rbyte & 0x7F);
            ++bytesRead;
            if ((rbyte & 0x80) != 0) continue;
            return new Tuple((Object)output, (Object)bytesRead);
        }
        throw new IllegalArgumentException("Invalid variable nat encoding. Unexpected bytes");
    }

    private byte[] getSubBytes(byte[] array, int startPosition) {
        if (startPosition < 0 || startPosition > array.length) {
            throw new IllegalArgumentException("Invalid start position");
        }
        return Arrays.copyOfRange(array, startPosition, array.length);
    }

    public Pointer getPointer() {
        return this.pointer;
    }
}

