/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.annotation.processor.blueprint;

import com.bloxbean.cardano.client.plutus.annotation.Blueprint;
import com.bloxbean.cardano.client.plutus.annotation.Constr;
import com.bloxbean.cardano.client.plutus.annotation.processor.blueprint.DataTypeProcessUtil;
import com.bloxbean.cardano.client.plutus.annotation.processor.blueprint.util.BlueprintUtil;
import com.bloxbean.cardano.client.plutus.annotation.processor.util.CodeGenUtil;
import com.bloxbean.cardano.client.plutus.annotation.processor.util.JavaFileUtil;
import com.bloxbean.cardano.client.plutus.blueprint.model.BlueprintDatatype;
import com.bloxbean.cardano.client.plutus.blueprint.model.BlueprintSchema;
import com.bloxbean.cardano.client.plutus.blueprint.model.Data;
import com.bloxbean.cardano.client.util.Tuple;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldSpecProcessor {
    private static final Logger log = LoggerFactory.getLogger(FieldSpecProcessor.class);
    private final ProcessingEnvironment processingEnv;
    private final Blueprint annotation;
    private final DataTypeProcessUtil dataTypeProcessUtil;

    public FieldSpecProcessor(Blueprint annotation, ProcessingEnvironment processingEnv) {
        this.annotation = annotation;
        this.processingEnv = processingEnv;
        this.dataTypeProcessUtil = new DataTypeProcessUtil(this, annotation, processingEnv);
    }

    public void createDatumClass(String ns, BlueprintSchema schema) {
        String dataClassName = schema.getTitle();
        if (dataClassName == null || dataClassName.isEmpty()) {
            return;
        }
        if (!(schema.getDataType() == null || !schema.getDataType().isPrimitiveType() || schema.getItems() != null || schema.getFields() != null && schema.getFields().size() != 0 || schema.getAnyOf() != null && schema.getAnyOf().size() != 0 || schema.getAllOf() != null && schema.getAllOf().size() != 0 || schema.getOneOf() != null && schema.getOneOf().size() != 0 || schema.getNotOf() != null && schema.getNotOf().size() != 0)) {
            return;
        }
        if ("Option".equals(dataClassName) && this.isOptionType(schema)) {
            return;
        }
        if ("Pair".equals(dataClassName) && schema.getDataType() == BlueprintDatatype.pair) {
            return;
        }
        dataClassName = JavaFileUtil.toClassNameFormat(dataClassName);
        if (this.createEnumIfPossible(ns, schema)) {
            return;
        }
        String interfaceName = null;
        if (schema.getAnyOf() != null && schema.getAnyOf().size() > 1) {
            log.debug("Create interface as size > 1 : " + schema.getTitle() + ", size: " + schema.getAnyOf().size());
            this.createDatumInterface(ns, dataClassName, schema);
            interfaceName = dataClassName;
        }
        Tuple<String, List<BlueprintSchema>> allFields = FieldSpecProcessor.collectAllFields(schema);
        for (BlueprintSchema innerSchema : (List)allFields._2) {
            dataClassName = schema.getTitle();
            if (dataClassName == null || dataClassName.isEmpty()) continue;
            dataClassName = JavaFileUtil.toClassNameFormat(dataClassName);
            this.createDatumFieldSpec(ns, interfaceName, innerSchema, dataClassName);
        }
    }

    private boolean isOptionType(BlueprintSchema schema) {
        if (schema.getAnyOf() == null || schema.getAnyOf().size() != 2) {
            return false;
        }
        BlueprintSchema someSchema = (BlueprintSchema)schema.getAnyOf().get(0);
        BlueprintSchema noneSchema = (BlueprintSchema)schema.getAnyOf().get(1);
        if (someSchema.getTitle() == null || noneSchema.getTitle() == null) {
            return false;
        }
        if (!"Some".equals(someSchema.getTitle()) || !"None".equals(noneSchema.getTitle())) {
            return false;
        }
        if (someSchema.getFields() == null || someSchema.getFields().size() != 1) {
            return false;
        }
        return noneSchema.getFields() == null || noneSchema.getFields().size() == 0;
    }

    private boolean createEnumIfPossible(String ns, BlueprintSchema schema) {
        if (schema.getAnyOf() == null || schema.getAnyOf().size() <= 1) {
            return false;
        }
        if (schema.getFields() != null && schema.getFields().size() != 0) {
            return false;
        }
        ArrayList<String> enumValues = new ArrayList<String>();
        for (BlueprintSchema anyOfSchema : schema.getAnyOf()) {
            if (BlueprintDatatype.constructor != anyOfSchema.getDataType()) {
                return false;
            }
            if (anyOfSchema.getTitle() == null || anyOfSchema.getTitle().isEmpty()) {
                return false;
            }
            if (anyOfSchema.getFields() != null && anyOfSchema.getFields().size() > 0) {
                return false;
            }
            enumValues.add(anyOfSchema.getTitle());
        }
        String pkg = this.getPackageName(ns);
        String enumClassName = JavaFileUtil.toClassNameFormat(schema.getTitle());
        TypeSpec.Builder enumConstrBuilder = TypeSpec.enumBuilder((String)enumClassName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(Constr.class).build());
        for (String value : enumValues) {
            enumConstrBuilder.addEnumConstant(value);
        }
        JavaFileUtil.createJavaFile(pkg, enumConstrBuilder.build(), enumClassName, this.processingEnv);
        return true;
    }

    public ClassName getInnerDatumClass(String ns, BlueprintSchema schema) {
        BlueprintSchema anyOfSchema;
        String dataClassName = schema.getTitle();
        if (dataClassName != null) {
            dataClassName = JavaFileUtil.toClassNameFormat(dataClassName);
        }
        String finalNS = BlueprintUtil.getNSFromReference(schema.getRef());
        String pkg = this.getPackageName(finalNS);
        if (schema.getAnyOf() != null && schema.getAnyOf().size() > 1) {
            log.debug("Create interface as size > 1 : " + schema.getTitle() + ", size: " + schema.getAnyOf().size());
            return ClassName.get((String)pkg, (String)dataClassName, (String[])new String[0]);
        }
        if (schema.getAnyOf() != null && schema.getAnyOf().size() == 1 && (dataClassName = (anyOfSchema = (BlueprintSchema)schema.getAnyOf().get(0)).getTitle()) != null) {
            dataClassName = JavaFileUtil.toClassNameFormat(dataClassName);
            return ClassName.get((String)pkg, (String)dataClassName, (String[])new String[0]);
        }
        return ClassName.get((String)pkg, (String)dataClassName, (String[])new String[0]);
    }

    public static Tuple<String, List<BlueprintSchema>> collectAllFields(BlueprintSchema schema) {
        ArrayList<BlueprintSchema> toFields = new ArrayList<BlueprintSchema>();
        String javaDoc = "";
        if (schema.getAllOf() != null) {
            toFields.addAll(schema.getAllOf());
            javaDoc = "AllOf";
        } else if (schema.getAnyOf() != null) {
            toFields.addAll(schema.getAnyOf());
            javaDoc = "AnyOf";
        } else if (schema.getOneOf() != null) {
            toFields.addAll(schema.getOneOf());
            javaDoc = "OneOf";
        } else {
            toFields.add(schema);
        }
        return new Tuple((Object)javaDoc, toFields);
    }

    public ClassName createDatumInterface(String ns, String dataClassName, BlueprintSchema schema) {
        AnnotationSpec constrAnnotationBuilder = AnnotationSpec.builder(Constr.class).build();
        String className = JavaFileUtil.toClassNameFormat(dataClassName);
        TypeSpec.Builder interfaceBuilder = TypeSpec.interfaceBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(constrAnnotationBuilder);
        TypeSpec build = interfaceBuilder.build();
        String pkg = this.getPackageName(ns);
        JavaFileUtil.createJavaFile(pkg, build, className, this.processingEnv);
        return ClassName.get((String)pkg, (String)className, (String[])new String[0]);
    }

    public Tuple<FieldSpec, ClassName> createDatumFieldSpec(String ns, String interfaceName, BlueprintSchema schema, String title) {
        String classNameString = JavaFileUtil.toClassNameFormat(title);
        TypeSpec redeemerJavaFile = this.createDatumTypeSpec(ns, interfaceName, schema);
        String className = redeemerJavaFile.name;
        log.debug("---------- Inside createDatumFieldSpec ---------");
        log.debug("ClasNameString : " + classNameString);
        log.debug("RedeemerJavaFile : " + redeemerJavaFile.name);
        if (schema.getRefSchema() != null) {
            String refTitle = schema.getRefSchema().getTitle();
            className = refTitle != null ? refTitle : className;
            className = JavaFileUtil.toClassNameFormat(className);
        }
        String finalNS = BlueprintUtil.getNSFromReference(schema.getRef());
        String pkg = this.getPackageName(finalNS);
        ClassName classNameType = ClassName.get((String)pkg, (String)className, (String[])new String[0]);
        String fieldName = title;
        fieldName = JavaFileUtil.firstLowerCase(JavaFileUtil.toCamelCase(fieldName));
        FieldSpec fieldSpec = FieldSpec.builder((TypeName)classNameType, (String)fieldName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
        return new Tuple((Object)fieldSpec, (Object)classNameType);
    }

    private TypeSpec createDatumTypeSpec(String ns, String interfaceName, BlueprintSchema schema) {
        Tuple<String, List<BlueprintSchema>> allInnerSchemas = FieldSpecProcessor.collectAllFields(schema);
        List<Object> fields = null;
        fields = schema.getDataType() != null ? this.createFieldSpecForDataTypes(ns, (String)allInnerSchemas._1, (List)allInnerSchemas._2) : new ArrayList();
        AnnotationSpec constrAnnotationBuilder = AnnotationSpec.builder(Constr.class).addMember("alternative", "$L", new Object[]{schema.getIndex()}).build();
        String title = schema.getTitle();
        String className = JavaFileUtil.toClassNameFormat(title);
        String pkg = this.getPackageName(ns);
        ClassName datumClass = ClassName.get((String)pkg, (String)className, (String[])new String[0]);
        ClassName DataClazz = ClassName.get(Data.class);
        ParameterizedTypeName parameterizedInterface = ParameterizedTypeName.get((ClassName)DataClazz, (TypeName[])new TypeName[]{datumClass});
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addFields(fields).addSuperinterface((TypeName)parameterizedInterface).addMethods(CodeGenUtil.createMethodSpecsForGetterSetters(fields, false)).addAnnotation(constrAnnotationBuilder);
        if (interfaceName != null && !interfaceName.isEmpty()) {
            ClassName interfaceTypeName = ClassName.get((String)pkg, (String)interfaceName, (String[])new String[0]);
            classBuilder.addSuperinterface((TypeName)interfaceTypeName);
        }
        TypeSpec build = classBuilder.build();
        log.debug("---------- Inside createDatumTypeSpec ---------");
        log.debug("Package: " + pkg);
        log.debug("Class: " + className);
        log.debug("Data type: " + schema.getDataType());
        log.debug("\n");
        if (schema.getDataType() != null) {
            JavaFileUtil.createJavaFile(pkg, build, className, this.processingEnv);
        } else {
            log.debug("Datatype is null. Looks like we don't need to create a class for this schema");
        }
        return build;
    }

    public List<FieldSpec> createFieldSpecForDataTypes(String ns, String javaDoc, List<BlueprintSchema> schemas) {
        ArrayList<FieldSpec> specs = new ArrayList<FieldSpec>();
        for (BlueprintSchema schema : schemas) {
            specs.addAll(this.createFieldSpecForDataTypes(ns, javaDoc, schema, "", schema.getTitle()));
        }
        return specs;
    }

    public List<FieldSpec> createFieldSpecForDataTypes(String ns, String javaDoc, BlueprintSchema schema, String className, String alternativeName) {
        ArrayList<FieldSpec> specs = new ArrayList<FieldSpec>();
        BlueprintDatatype schemaType = schema.getDataType();
        if (schemaType == null) {
            specs.add(this.dataTypeProcessUtil.processPlutusDataType(javaDoc, schema, alternativeName));
        } else {
            switch (schemaType) {
                case bytes: {
                    specs.add(this.dataTypeProcessUtil.processBytesDataType(javaDoc, schema, alternativeName));
                    break;
                }
                case integer: {
                    specs.add(this.dataTypeProcessUtil.processIntegerDataType(javaDoc, schema, alternativeName));
                    break;
                }
                case bool: {
                    specs.add(this.dataTypeProcessUtil.processBoolDataType(javaDoc, schema, alternativeName));
                    break;
                }
                case list: {
                    specs.add(this.dataTypeProcessUtil.processListDataType(ns, javaDoc, schema, alternativeName));
                    break;
                }
                case map: {
                    specs.add(this.dataTypeProcessUtil.processMapDataType(ns, javaDoc, schema, className, alternativeName));
                    break;
                }
                case constructor: {
                    specs.addAll(this.dataTypeProcessUtil.processConstructorDataType(ns, javaDoc, schema, className, alternativeName));
                    break;
                }
                case string: {
                    specs.add(this.dataTypeProcessUtil.processStringDataType(javaDoc, schema, alternativeName));
                    break;
                }
                case option: {
                    specs.add(this.dataTypeProcessUtil.processOptionDataType(ns, javaDoc, schema, alternativeName));
                    break;
                }
                case pair: {
                    specs.add(this.dataTypeProcessUtil.processPairDataType(ns, javaDoc, schema, alternativeName));
                    break;
                }
            }
        }
        return specs;
    }

    private String getPackageName(String ns) {
        String pkg = ns != null && !ns.isEmpty() ? this.annotation.packageName() + "." + ns + ".model" : this.annotation.packageName() + ".model";
        return JavaFileUtil.toPackageNameFormat(pkg);
    }
}

