/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.annotation.processor;

import com.bloxbean.cardano.client.plutus.annotation.Constr;
import com.bloxbean.cardano.client.plutus.annotation.processor.ClassDefinitionGenerator;
import com.bloxbean.cardano.client.plutus.annotation.processor.ConverterCodeGenerator;
import com.bloxbean.cardano.client.plutus.annotation.processor.DataImplGenerator;
import com.bloxbean.cardano.client.plutus.annotation.processor.model.ClassDefinition;
import com.bloxbean.cardano.client.plutus.annotation.processor.util.JavaFileUtil;
import com.google.auto.service.AutoService;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Processor.class})
public class ConstrAnnotationProcessor
extends AbstractProcessor {
    private static final Logger log = LoggerFactory.getLogger(ConstrAnnotationProcessor.class);
    private Messager messager;
    private ClassDefinitionGenerator classDefinitionGenerator;
    private ConverterCodeGenerator serializerCodeGenerator;
    private DataImplGenerator dataImplGenerator;
    private List<TypeElement> typeElements = new ArrayList<TypeElement>();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.classDefinitionGenerator = new ClassDefinitionGenerator(processingEnv);
        this.serializerCodeGenerator = new ConverterCodeGenerator(processingEnv);
        this.dataImplGenerator = new DataImplGenerator(processingEnv);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotataions = new LinkedHashSet<String>();
        annotataions.add(Constr.class.getCanonicalName());
        return annotataions;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ArrayList<TypeElement> interfaceElements = new ArrayList<TypeElement>();
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : set) {
                if (!(element instanceof TypeElement)) continue;
                TypeElement typeElement2 = (TypeElement)element;
                this.typeElements.add(typeElement2);
                if (!typeElement2.getKind().isInterface()) continue;
                interfaceElements.add(typeElement2);
            }
        }
        this.classDefinitionGenerator.setTypeElements(this.typeElements);
        HashMap<TypeElement, ArrayList<ClassDefinition>> interfaceToConstructorsMap = new HashMap<TypeElement, ArrayList<ClassDefinition>>();
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : elements) {
                TypeElement typeElement3;
                if (!(element instanceof TypeElement) || (typeElement3 = (TypeElement)element).getKind().isInterface()) continue;
                ClassDefinition classDefinition = this.classDefinitionGenerator.getClassDefinition(typeElement3);
                List<? extends TypeMirror> interfaces = typeElement3.getInterfaces();
                for (TypeMirror typeMirror : interfaces) {
                    TypeElement interfaceElement = (TypeElement)this.processingEnv.getTypeUtils().asElement(typeMirror);
                    if (!interfaceElements.contains(interfaceElement)) continue;
                    ArrayList<ClassDefinition> constructors = (ArrayList<ClassDefinition>)interfaceToConstructorsMap.get(interfaceElement);
                    if (constructors == null) {
                        constructors = new ArrayList<ClassDefinition>();
                        interfaceToConstructorsMap.put(interfaceElement, constructors);
                    }
                    constructors.add(classDefinition);
                }
                if (classDefinition.isEnum()) {
                    this.serializerCodeGenerator.generateEnumConverter(classDefinition).ifPresent(typeSpec -> JavaFileUtil.createJavaFile(classDefinition.getConverterPackageName(), typeSpec, classDefinition.getConverterClassName(), this.processingEnv));
                } else {
                    try {
                        TypeSpec typeSpec2 = this.serializerCodeGenerator.generate(classDefinition);
                        JavaFileUtil.createJavaFile(classDefinition.getConverterPackageName(), typeSpec2, classDefinition.getConverterClassName(), this.processingEnv);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.error("Failed to generate serialization class: " + e.getMessage(), (Throwable)e);
                        this.error(typeElement3, "Failed to generate serialization class for " + typeElement3.getQualifiedName(), new Object[0]);
                    }
                }
                try {
                    TypeSpec typeSpec2 = this.dataImplGenerator.generate(classDefinition);
                    JavaFileUtil.createJavaFile(classDefinition.getImplPackageName(), typeSpec2, classDefinition.getImplClassName(), this.processingEnv);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("Failed to generate DataImpl class: " + e.getMessage(), (Throwable)e);
                    this.error(typeElement3, "Failed to generate DataImpl class for " + typeElement3.getQualifiedName(), new Object[0]);
                }
            }
        }
        for (Map.Entry entry : interfaceToConstructorsMap.entrySet()) {
            TypeElement interfaceElement = (TypeElement)entry.getKey();
            List list = (List)entry.getValue();
            ClassDefinition classDefinition = this.classDefinitionGenerator.getClassDefinition(interfaceElement);
            try {
                TypeSpec typeSpec3 = this.serializerCodeGenerator.generateInterfaceConverter(classDefinition, list);
                JavaFileUtil.createJavaFile(classDefinition.getConverterPackageName(), typeSpec3, classDefinition.getConverterClassName(), this.processingEnv);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("Failed to generate converter class: " + e.getMessage(), (Throwable)e);
                this.error(interfaceElement, "Failed to generate converter class for " + interfaceElement.getQualifiedName(), new Object[0]);
            }
        }
        return true;
    }

    private void error(Element e, String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }
}

