/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.annotation.processor.util;

import com.bloxbean.cardano.client.plutus.annotation.processor.util.JavaFileUtil;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.Modifier;

public class CodeGenUtil {
    public static Collection<MethodSpec> createMethodSpecsForGetterSetters(List<FieldSpec> fields, boolean onlyGetter) {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        for (FieldSpec field : fields) {
            String methodName;
            String fieldName = field.name;
            if (field.type == TypeName.BOOLEAN) {
                methodName = "is" + JavaFileUtil.firstUpperCase(fieldName);
                MethodSpec isMethod = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN).addStatement("return this.$N", new Object[]{fieldName}).build();
                methods.add(isMethod);
            } else {
                methodName = "get" + JavaFileUtil.firstUpperCase(fieldName);
                MethodSpec getter = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(field.type).addStatement("return this.$N", new Object[]{fieldName}).build();
                methods.add(getter);
            }
            if (onlyGetter) continue;
            methodName = "set" + JavaFileUtil.firstUpperCase(fieldName);
            MethodSpec setter = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.VOID).addParameter(field.type, fieldName, new Modifier[0]).addStatement("this.$N = $N", new Object[]{fieldName, fieldName}).build();
            methods.add(setter);
        }
        return methods;
    }
}

