/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.annotation.processor.util;

import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.Writer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.apache.commons.text.CaseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaFileUtil {
    private static final Logger log = LoggerFactory.getLogger(JavaFileUtil.class);
    public static final String CARDANO_CLIENT_LIB_GENERATED_DIR = "cardano.client.lib.generated.dir";

    public static String firstUpperCase(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static String firstLowerCase(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    public static String toCamelCase(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return CaseUtils.toCamelCase((String)s, (boolean)true, (char[])new char[]{'_', ' ', '-'});
    }

    public static String toClassNameFormat(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        return JavaFileUtil.firstUpperCase(JavaFileUtil.toCamelCase(s));
    }

    public static String toPackageNameFormat(String pkg) {
        if (pkg == null) {
            return null;
        }
        return pkg.toLowerCase().replace("-", "").replace("_", "");
    }

    public static void createJavaFile(String packageName, TypeSpec build, String className, ProcessingEnvironment processingEnv) {
        String generatedDir = processingEnv.getOptions().get(CARDANO_CLIENT_LIB_GENERATED_DIR);
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)build).build();
        JavaFileObject builderFile = null;
        try {
            String fullClassName = packageName + "." + className;
            builderFile = processingEnv.getFiler().createSourceFile(fullClassName, new Element[0]);
            if (generatedDir == null) {
                Writer writer = builderFile.openWriter();
                javaFile.writeTo((Appendable)writer);
                writer.close();
            } else {
                javaFile.writeTo(new File(generatedDir));
            }
        }
        catch (Exception e) {
            log.error("Error creating class : " + className, (Throwable)e);
            JavaFileUtil.warn(processingEnv, null, "Error creating class: %s, package: %s, error: %s", className, packageName, e.getMessage());
        }
    }

    public static void error(ProcessingEnvironment processingEnv, Element e, String msg, Object ... args) {
        processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    public static void warn(ProcessingEnvironment processingEnv, Element e, String msg, Object ... args) {
        processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, String.format(msg, args), e);
    }
}

