/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.annotation.processor;

import com.bloxbean.cardano.client.plutus.annotation.Constr;
import com.bloxbean.cardano.client.plutus.annotation.Enc;
import com.bloxbean.cardano.client.plutus.annotation.PlutusIgnore;
import com.bloxbean.cardano.client.plutus.annotation.processor.exception.NotSupportedException;
import com.bloxbean.cardano.client.plutus.annotation.processor.model.ClassDefinition;
import com.bloxbean.cardano.client.plutus.annotation.processor.model.Field;
import com.bloxbean.cardano.client.plutus.annotation.processor.model.FieldType;
import com.bloxbean.cardano.client.plutus.annotation.processor.model.JavaType;
import com.bloxbean.cardano.client.plutus.annotation.processor.model.Type;
import com.bloxbean.cardano.client.plutus.blueprint.type.Pair;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassDefinitionGenerator {
    private static final Logger log = LoggerFactory.getLogger(ClassDefinitionGenerator.class);
    private ProcessingEnvironment processingEnvironment;
    private Elements elements;
    private List<TypeElement> typeElements = null;

    public ClassDefinitionGenerator(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
        this.elements = processingEnvironment.getElementUtils();
    }

    public void setTypeElements(List<TypeElement> typeElements) {
        this.typeElements = typeElements;
    }

    public ClassDefinition getClassDefinition(TypeElement typeElement) {
        String packageName = this.processingEnvironment.getElementUtils().getPackageOf(typeElement).toString();
        String className = typeElement.getSimpleName().toString();
        String converterClassName = className + "Converter";
        ClassDefinition classDefinition = new ClassDefinition();
        classDefinition.setPackageName(packageName);
        classDefinition.setName(className);
        classDefinition.setDataClassName(className);
        classDefinition.setImplClassName(className + "Data");
        classDefinition.setConverterClassName(converterClassName);
        classDefinition.setObjType(typeElement.asType().toString());
        typeElement.getModifiers().stream().filter(modifier -> modifier.equals((Object)Modifier.ABSTRACT)).findFirst().ifPresent(modifier -> classDefinition.setAbstract(true));
        if (typeElement.getKind() == ElementKind.ENUM) {
            this.processEnum(typeElement, classDefinition);
        }
        classDefinition.setConverterPackageName(ClassDefinitionGenerator.getConverterPackageName(packageName));
        classDefinition.setImplPackageName(ClassDefinitionGenerator.getImplPackageName(packageName));
        try {
            boolean lombokSetter;
            Class<?> lombokDataClazz = Class.forName("lombok.Data");
            Class<?> lombokGetterClazz = Class.forName("lombok.Getter");
            Class<?> lombokSetterClazz = Class.forName("lombok.Setter");
            boolean lombokData = typeElement.getAnnotation(lombokDataClazz) != null;
            boolean lombokGetter = typeElement.getAnnotation(lombokGetterClazz) != null;
            boolean bl = lombokSetter = typeElement.getAnnotation(lombokSetterClazz) != null;
            if (lombokData || lombokGetter && lombokSetter) {
                classDefinition.setHasLombokAnnotation(true);
            }
        }
        catch (Exception lombokData) {
            // empty catch block
        }
        Constr plutusConstr = typeElement.getAnnotation(Constr.class);
        int alternative = plutusConstr.alternative();
        classDefinition.setAlternative(alternative);
        int index = 0;
        for (Element element : typeElement.getEnclosedElements()) {
            boolean isFieldVisible;
            if (!(element instanceof VariableElement) || element.getAnnotation(PlutusIgnore.class) != null) continue;
            Field field = new Field();
            field.setIndex(index++);
            VariableElement variableElement = (VariableElement)element;
            String fieldName = variableElement.getSimpleName().toString();
            field.setName(fieldName);
            field.setAlternative(this.getAlternative(fieldName));
            ExecutableElement getter = this.findGetter(typeElement, variableElement);
            ExecutableElement setter = this.findSetter(typeElement, variableElement);
            boolean bl = isFieldVisible = variableElement.getModifiers().contains((Object)Modifier.PUBLIC) || variableElement.getModifiers().size() == 0;
            if (!(getter != null && setter != null || isFieldVisible || classDefinition.isHasLombokAnnotation())) {
                this.error(variableElement, "Getter / Setter method not found for field: " + fieldName, new Object[0]);
                continue;
            }
            TypeName typeName = TypeName.get((TypeMirror)variableElement.asType());
            FieldType fieldType = null;
            try {
                fieldType = this.detectFieldType(typeName, variableElement.asType());
            }
            catch (NotSupportedException e) {
                this.error(variableElement, e.getMessage(), new Object[0]);
            }
            field.setFieldType(fieldType);
            if (getter != null && setter != null) {
                field.setHashGetter(true);
                field.setGetterName(getter.getSimpleName().toString());
            } else if (classDefinition.isHasLombokAnnotation()) {
                field.setHashGetter(true);
                if (Type.BOOL.equals((Object)field.getFieldType().getType())) {
                    if (JavaType.BOOLEAN.equals(field.getFieldType().getJavaType())) {
                        field.setGetterName("is" + this.capitalize(fieldName));
                    } else {
                        field.setGetterName("get" + this.capitalize(fieldName));
                    }
                } else {
                    field.setGetterName("get" + this.capitalize(fieldName));
                }
            }
            Enc encodingField = variableElement.getAnnotation(Enc.class);
            if (encodingField != null && encodingField.value() != null) {
                field.getFieldType().setEncoding(encodingField.value());
            }
            classDefinition.getFields().add(field);
        }
        return classDefinition;
    }

    private int getAlternative(String fieldName) {
        Optional<TypeElement> first = this.typeElements.stream().filter(typeElement -> typeElement.getSimpleName().toString().toLowerCase().equals(fieldName.toLowerCase())).findFirst();
        if (first.isPresent()) {
            TypeElement typeElement2 = first.get();
            return typeElement2.getAnnotation(Constr.class).alternative();
        }
        return 0;
    }

    private FieldType detectFieldType(TypeName typeName, TypeMirror typeMirror) throws NotSupportedException {
        FieldType fieldType = new FieldType();
        fieldType.setFqTypeName(typeName.toString());
        if (typeName.equals((Object)TypeName.get(Long.class))) {
            fieldType.setType(Type.INTEGER);
            fieldType.setJavaType(JavaType.LONG_OBJECT);
        } else if (typeName.equals((Object)TypeName.LONG)) {
            fieldType.setType(Type.INTEGER);
            fieldType.setJavaType(JavaType.LONG);
        } else if (typeName.equals((Object)TypeName.get(BigInteger.class))) {
            fieldType.setType(Type.INTEGER);
            fieldType.setJavaType(JavaType.BIGINTEGER);
        } else if (typeName.equals((Object)TypeName.get(Integer.class))) {
            fieldType.setType(Type.INTEGER);
            fieldType.setJavaType(JavaType.INTEGER);
        } else if (typeName.equals((Object)TypeName.INT)) {
            fieldType.setType(Type.INTEGER);
            fieldType.setJavaType(JavaType.INT);
        } else if (typeName.equals((Object)TypeName.get(String.class))) {
            fieldType.setType(Type.STRING);
            fieldType.setJavaType(JavaType.STRING);
        } else if (typeName.equals((Object)TypeName.get(byte[].class))) {
            fieldType.setType(Type.BYTES);
            fieldType.setJavaType(JavaType.BYTES);
        } else if (typeName.equals((Object)TypeName.get(Boolean.class))) {
            fieldType.setType(Type.BOOL);
            fieldType.setJavaType(JavaType.BOOLEAN_OBJ);
        } else if (typeName.equals((Object)TypeName.BOOLEAN)) {
            fieldType.setType(Type.BOOL);
            fieldType.setJavaType(JavaType.BOOLEAN);
        } else if (typeName.equals((Object)TypeName.get(PlutusData.class))) {
            fieldType.setType(Type.PLUTUSDATA);
            fieldType.setJavaType(JavaType.PLUTUSDATA);
        } else if (typeName instanceof ParameterizedTypeName && (((ParameterizedTypeName)typeName).rawType.equals((Object)ClassName.get(List.class)) || this.isAssignableToList(typeMirror))) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
            TypeName itemType = (TypeName)parameterizedTypeName.typeArguments.get(0);
            fieldType.setType(Type.LIST);
            fieldType.setJavaType(JavaType.LIST);
            fieldType.setCollection(true);
            fieldType.getGenericTypes().add(this.detectFieldType(itemType, null));
        } else if (typeName instanceof ParameterizedTypeName && (((ParameterizedTypeName)typeName).rawType.equals((Object)ClassName.get(Map.class)) || this.isAssignableToMap(typeMirror))) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
            TypeName keyItemType = (TypeName)parameterizedTypeName.typeArguments.get(0);
            TypeName valueItemType = (TypeName)parameterizedTypeName.typeArguments.get(1);
            fieldType.setType(Type.MAP);
            fieldType.setJavaType(JavaType.MAP);
            fieldType.setCollection(true);
            fieldType.getGenericTypes().add(this.detectFieldType(keyItemType, null));
            fieldType.getGenericTypes().add(this.detectFieldType(valueItemType, null));
        } else if (typeName instanceof ParameterizedTypeName && ((ParameterizedTypeName)typeName).rawType.equals((Object)ClassName.get(Optional.class))) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
            TypeName itemType = (TypeName)parameterizedTypeName.typeArguments.get(0);
            fieldType.setType(Type.OPTIONAL);
            fieldType.setJavaType(JavaType.OPTIONAL);
            fieldType.getGenericTypes().add(this.detectFieldType(itemType, null));
        } else if (typeName instanceof ParameterizedTypeName && ((ParameterizedTypeName)typeName).rawType.equals((Object)ClassName.get(Pair.class))) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
            TypeName firstElementType = (TypeName)parameterizedTypeName.typeArguments.get(0);
            TypeName secondElementType = (TypeName)parameterizedTypeName.typeArguments.get(1);
            fieldType.setType(Type.PAIR);
            fieldType.setJavaType(JavaType.PAIR);
            fieldType.getGenericTypes().add(this.detectFieldType(firstElementType, null));
            fieldType.getGenericTypes().add(this.detectFieldType(secondElementType, null));
        } else if (this.isSupportedType(typeName, typeMirror)) {
            fieldType.setType(Type.CONSTRUCTOR);
            fieldType.setJavaType(new JavaType(typeName.toString(), true));
        } else {
            throw new NotSupportedException("Type not supported: " + typeName);
        }
        return fieldType;
    }

    private boolean isSupportedType(TypeName typeName, TypeMirror typeMirror) {
        for (TypeElement typeElement : this.typeElements) {
            if (typeMirror != null && typeElement.asType().equals(typeMirror)) {
                return true;
            }
            if (!typeElement.getQualifiedName().toString().equals(typeName.toString())) continue;
            return true;
        }
        return true;
    }

    private ExecutableElement findGetter(TypeElement typeElement, VariableElement variableElement) {
        String fieldName = variableElement.getSimpleName().toString();
        String getterMethodName = "get" + this.capitalize(fieldName.toString());
        String altGetterMethodName = null;
        if (variableElement.asType().getKind().equals((Object)TypeKind.BOOLEAN) || variableElement.asType().toString().equals("java.lang.Boolean")) {
            altGetterMethodName = "is" + this.capitalize(fieldName.toString());
        }
        for (Element element : typeElement.getEnclosedElements()) {
            ExecutableElement executableElement;
            if (!(element instanceof ExecutableElement) || !(executableElement = (ExecutableElement)element).getSimpleName().toString().equals(getterMethodName) && !executableElement.getSimpleName().toString().equals(altGetterMethodName) || !executableElement.getModifiers().contains((Object)Modifier.PUBLIC) || !executableElement.getParameters().isEmpty() || !executableElement.getReturnType().toString().equals(variableElement.asType().toString())) continue;
            return executableElement;
        }
        return null;
    }

    private ExecutableElement findSetter(TypeElement typeElement, VariableElement variableElement) {
        String fieldName = variableElement.getSimpleName().toString();
        String setterName = "set" + this.capitalize(fieldName.toString());
        for (Element element : typeElement.getEnclosedElements()) {
            ExecutableElement executableElement;
            if (!(element instanceof ExecutableElement) || !(executableElement = (ExecutableElement)element).getSimpleName().toString().equals(setterName) || !executableElement.getModifiers().contains((Object)Modifier.PUBLIC) || executableElement.getParameters().size() != 1 || !executableElement.getParameters().get(0).asType().toString().equals(variableElement.asType().toString()) || !executableElement.getReturnType().getKind().equals((Object)TypeKind.VOID)) continue;
            return executableElement;
        }
        return null;
    }

    private String capitalize(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private void error(Element e, String msg, Object ... args) {
        this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    private boolean isAssignableToMap(TypeMirror typeMirror) {
        if (typeMirror == null) {
            return false;
        }
        Types typeUtils = this.processingEnvironment.getTypeUtils();
        return typeUtils.isAssignable(typeMirror, typeUtils.getDeclaredType(this.elements.getTypeElement("java.util.Map"), new TypeMirror[0]));
    }

    private boolean isAssignableToList(TypeMirror typeMirror) {
        if (typeMirror == null) {
            return false;
        }
        Types typeUtils = this.processingEnvironment.getTypeUtils();
        return typeUtils.isAssignable(typeMirror, typeUtils.getDeclaredType(this.elements.getTypeElement("java.util.List"), new TypeMirror[0]));
    }

    public static ClassName getConverterClassFromField(FieldType fieldType) {
        ClassName fieldClass = ClassName.bestGuess((String)fieldType.getJavaType().getName());
        String converterPkg = ClassDefinitionGenerator.getConverterPackageName(fieldClass.packageName());
        ClassName converterClass = ClassName.get((String)converterPkg, (String)(fieldClass.simpleName() + "Converter"), (String[])new String[0]);
        return converterClass;
    }

    private static String getConverterPackageName(String modelPackage) {
        return modelPackage + ".converter";
    }

    private static String getImplPackageName(String modelPackage) {
        return modelPackage + ".impl";
    }

    private void processEnum(TypeElement typeElement, ClassDefinition classDefinition) {
        log.debug("Found enum: " + typeElement.getQualifiedName());
        classDefinition.setEnum(true);
        ArrayList<String> enumValues = new ArrayList<String>();
        for (Element element : typeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            VariableElement variableElement = (VariableElement)element;
            log.debug("Enum constant: " + variableElement.getSimpleName());
            enumValues.add(variableElement.getSimpleName().toString());
        }
        classDefinition.setEnumValues(enumValues);
    }
}

