/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.annotation.processor;

import com.bloxbean.cardano.client.plutus.annotation.processor.CodeGenerator;
import com.bloxbean.cardano.client.plutus.annotation.processor.model.ClassDefinition;
import com.bloxbean.cardano.client.plutus.annotation.processor.util.JavaFileUtil;
import com.bloxbean.cardano.client.plutus.blueprint.model.Data;
import com.bloxbean.cardano.client.plutus.spec.ConstrPlutusData;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;

public class DataImplGenerator
implements CodeGenerator {
    private ProcessingEnvironment processingEnvironment;

    public DataImplGenerator(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
    }

    @Override
    public TypeSpec generate(ClassDefinition classDef) {
        String dataImplClassName = classDef.getImplClassName();
        ClassName converterClass = ClassName.bestGuess((String)(classDef.getConverterPackageName() + "." + classDef.getConverterClassName()));
        ClassName dataClass = ClassName.bestGuess((String)(classDef.getPackageName() + "." + classDef.getDataClassName()));
        ClassName dataClassImpl = ClassName.bestGuess((String)(classDef.getImplPackageName() + "." + classDef.getImplClassName()));
        ClassName DataClazz = ClassName.get(Data.class);
        ParameterizedTypeName parameterizedInterface = ParameterizedTypeName.get((ClassName)DataClazz, (TypeName[])new TypeName[]{dataClass});
        if (classDef.isEnum()) {
            TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)dataImplClassName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)parameterizedInterface);
            return this.generateEnumDataImpl(classBuilder, converterClass, dataClass, dataClassImpl);
        }
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)dataImplClassName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)parameterizedInterface).superclass((TypeName)dataClass);
        return this.generateDataImpl(classBuilder, converterClass, dataClass);
    }

    private TypeSpec generateDataImpl(TypeSpec.Builder classBuilder, ClassName converterClass, ClassName dataClass) {
        FieldSpec converterField = FieldSpec.builder((TypeName)converterClass, (String)"converter", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).addModifiers(new Modifier[]{Modifier.STATIC}).initializer("new $T()", new Object[]{converterClass}).build();
        MethodSpec constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).build();
        return classBuilder.addJavadoc("Auto generated code. DO NOT MODIFY", new Object[0]).addField(converterField).addMethod(constructor).addMethod(this.getToPlutusDataMethodSpec(dataClass)).addMethod(this.getFromPlutusDataMethodSpec(dataClass)).addMethod(this.getDeserializeMethodByString(dataClass)).addMethod(this.getDeserializeMethodByBytes(dataClass)).build();
    }

    private MethodSpec getToPlutusDataMethodSpec(ClassName dataClass) {
        MethodSpec toPlutusDataMethod = MethodSpec.methodBuilder((String)"toPlutusData").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ClassName.get(ConstrPlutusData.class)).addStatement("return converter.toPlutusData(($T)this)", new Object[]{dataClass}).build();
        return toPlutusDataMethod;
    }

    private MethodSpec getFromPlutusDataMethodSpec(ClassName dataClass) {
        MethodSpec fromPlutusDataMethod = MethodSpec.methodBuilder((String)"fromPlutusData").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)dataClass).addParameter((TypeName)ClassName.get(ConstrPlutusData.class), "data", new Modifier[0]).addStatement("return converter.fromPlutusData(data)", new Object[0]).build();
        return fromPlutusDataMethod;
    }

    private MethodSpec getDeserializeMethodByString(ClassName dataClass) {
        MethodSpec deserialize = MethodSpec.methodBuilder((String)"deserialize").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)dataClass).addParameter(String.class, "cborHex", new Modifier[0]).addStatement("return converter.deserialize(cborHex)", new Object[0]).build();
        return deserialize;
    }

    private MethodSpec getDeserializeMethodByBytes(ClassName dataClass) {
        MethodSpec deserialize = MethodSpec.methodBuilder((String)"deserialize").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)dataClass).addParameter(byte[].class, "cborBytes", new Modifier[0]).addStatement("return converter.deserialize(cborBytes)", new Object[0]).build();
        return deserialize;
    }

    private TypeSpec generateEnumDataImpl(TypeSpec.Builder classBuilder, ClassName converterClass, ClassName dataClass, ClassName dataClassImpl) {
        String dataClassFieldName = JavaFileUtil.firstLowerCase(dataClass.simpleName());
        FieldSpec dataClassFieldSpec = FieldSpec.builder((TypeName)dataClass, (String)dataClassFieldName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
        FieldSpec converterField = FieldSpec.builder((TypeName)converterClass, (String)"converter", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).initializer("new $T()", new Object[]{converterClass}).build();
        MethodSpec constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)dataClass, dataClassFieldName, new Modifier[0]).addStatement("this.$N = $N", new Object[]{dataClassFieldName, dataClassFieldName}).build();
        MethodSpec ofMethod = MethodSpec.methodBuilder((String)"of").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter((TypeName)dataClass, dataClassFieldName, new Modifier[0]).returns((TypeName)dataClassImpl).addStatement("return new $T($N)", new Object[]{dataClassImpl, dataClassFieldName}).build();
        MethodSpec toPlutusDataMethod = MethodSpec.methodBuilder((String)"toPlutusData").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ClassName.get(ConstrPlutusData.class)).addStatement("return converter.toPlutusData($N)", new Object[]{dataClassFieldName}).build();
        return classBuilder.addJavadoc("Auto generated code. DO NOT MODIFY", new Object[0]).addField(dataClassFieldSpec).addField(converterField).addMethod(constructor).addMethod(ofMethod).addMethod(toPlutusDataMethod).addMethod(this.getFromPlutusDataMethodSpec(dataClass)).addMethod(this.getDeserializeMethodByString(dataClass)).addMethod(this.getDeserializeMethodByBytes(dataClass)).build();
    }
}

