/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.annotation.processor.blueprint;

import com.bloxbean.cardano.client.plutus.annotation.Blueprint;
import com.bloxbean.cardano.client.plutus.annotation.ExtendWith;
import com.bloxbean.cardano.client.plutus.annotation.processor.blueprint.FieldSpecProcessor;
import com.bloxbean.cardano.client.plutus.annotation.processor.blueprint.ValidatorProcessor;
import com.bloxbean.cardano.client.plutus.annotation.processor.blueprint.util.BlueprintUtil;
import com.bloxbean.cardano.client.plutus.annotation.processor.util.JavaFileUtil;
import com.bloxbean.cardano.client.plutus.blueprint.PlutusBlueprintLoader;
import com.bloxbean.cardano.client.plutus.blueprint.model.BlueprintSchema;
import com.bloxbean.cardano.client.plutus.blueprint.model.PlutusContractBlueprint;
import com.bloxbean.cardano.client.plutus.blueprint.model.Validator;
import com.google.auto.service.AutoService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Processor.class})
public class BlueprintAnnotationProcessor
extends AbstractProcessor {
    private static final Logger log = LoggerFactory.getLogger(BlueprintAnnotationProcessor.class);
    private Messager messager;
    private List<TypeElement> typeElements = new ArrayList<TypeElement>();
    private ValidatorProcessor validatorProcessor;
    private FieldSpecProcessor fieldSpecProcessor;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotataions = new LinkedHashSet<String>();
        annotataions.add(Blueprint.class.getCanonicalName());
        return annotataions;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        log.debug("Processing Blueprint annotation");
        this.typeElements = this.getTypeElementsWithAnnotations(annotations, roundEnv);
        for (TypeElement typeElement : this.typeElements) {
            PlutusContractBlueprint plutusContractBlueprint;
            Blueprint annotation = typeElement.getAnnotation(Blueprint.class);
            ExtendWith[] extendWiths = (ExtendWith[])typeElement.getAnnotationsByType(ExtendWith.class);
            ExtendWith extendWith = null;
            if (extendWiths != null && extendWiths.length > 1) {
                this.error(typeElement, "Multiple ExtendWith annotations are not supported. Only one ExtendWith annotation is allowed.", new Object[0]);
                return false;
            }
            if (extendWiths != null && extendWiths.length == 1) {
                extendWith = extendWiths[0];
            }
            if (annotation == null) {
                this.error(typeElement, "Blueprint annotation not found for class %s", typeElement.getSimpleName());
                return false;
            }
            this.validatorProcessor = new ValidatorProcessor(annotation, extendWith, this.processingEnv);
            this.fieldSpecProcessor = new FieldSpecProcessor(annotation, this.processingEnv);
            File blueprintFile = this.getFileFromAnnotation(annotation);
            if (blueprintFile == null || !blueprintFile.exists()) {
                this.error(typeElement, "Blueprint file %s not found", annotation.fileInResources());
                return false;
            }
            try {
                plutusContractBlueprint = PlutusBlueprintLoader.loadBlueprint((File)blueprintFile);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error(typeElement, "Error processing blueprint file %s", blueprintFile.getAbsolutePath(), e);
                return false;
            }
            Map definitions = plutusContractBlueprint.getDefinitions() != null ? plutusContractBlueprint.getDefinitions() : Collections.EMPTY_MAP;
            for (Map.Entry definition : definitions.entrySet()) {
                String key = (String)definition.getKey();
                String ns = BlueprintUtil.getNSFromReferenceKey(key);
                this.fieldSpecProcessor.createDatumClass(ns, (BlueprintSchema)definition.getValue());
            }
            for (Validator validator : plutusContractBlueprint.getValidators()) {
                this.validatorProcessor.processValidator(validator, plutusContractBlueprint.getPreamble().getPlutusVersion());
            }
        }
        return true;
    }

    private List<TypeElement> getTypeElementsWithAnnotations(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ArrayList<TypeElement> elementsList = new ArrayList<TypeElement>();
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : elements) {
                if (!(element instanceof TypeElement)) continue;
                TypeElement typeElement2 = (TypeElement)element;
                elementsList.add(typeElement2);
            }
        }
        return elementsList;
    }

    private File getFileFromAnnotation(Blueprint annotation) {
        File blueprintFile = null;
        if (!annotation.file().isEmpty()) {
            blueprintFile = new File(annotation.file());
        }
        if (!annotation.fileInResources().isEmpty()) {
            blueprintFile = this.getFileFromResources(annotation.fileInResources());
        }
        if (blueprintFile == null || !blueprintFile.exists()) {
            log.error("Blueprint file %s not found", (Object)annotation.file());
            if (blueprintFile != null) {
                JavaFileUtil.warn(this.processingEnv, null, "Trying to find blueprint file at " + blueprintFile.getAbsolutePath(), new Object[0]);
            }
            return null;
        }
        return blueprintFile;
    }

    public File getFileFromResources(String s) {
        FileObject resource2;
        try {
            resource2 = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_PATH, "", s);
            File f = new File(resource2.toUri());
            if (f.exists()) {
                return f;
            }
        }
        catch (Exception resource2) {
            // empty catch block
        }
        try {
            resource2 = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", s);
            return new File(resource2.toUri());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void error(Element e, String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }
}

