/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.annotation.processor.blueprint;

import com.bloxbean.cardano.client.plutus.annotation.Blueprint;
import com.bloxbean.cardano.client.plutus.annotation.Constr;
import com.bloxbean.cardano.client.plutus.annotation.processor.blueprint.FieldSpecProcessor;
import com.bloxbean.cardano.client.plutus.annotation.processor.util.JavaFileUtil;
import com.bloxbean.cardano.client.plutus.blueprint.model.BlueprintDatatype;
import com.bloxbean.cardano.client.plutus.blueprint.model.BlueprintSchema;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;

public class DataTypeProcessUtil {
    private final FieldSpecProcessor fieldSpecProcessor;
    private final Blueprint annotation;
    private final ProcessingEnvironment processingEnv;

    public DataTypeProcessUtil(FieldSpecProcessor fieldSpecProcessor, Blueprint annotation, ProcessingEnvironment processingEnv) {
        this.fieldSpecProcessor = fieldSpecProcessor;
        this.annotation = annotation;
        this.processingEnv = processingEnv;
    }

    public FieldSpec processIntegerDataType(String javaDoc, BlueprintSchema schema, String alternativeName) {
        if (schema.getDataType() != BlueprintDatatype.integer) {
            throw new IllegalArgumentException("Schema is not of type integer");
        }
        String title = schema.getTitle() == null ? alternativeName : schema.getTitle();
        title = JavaFileUtil.firstLowerCase(JavaFileUtil.toCamelCase(title));
        return FieldSpec.builder(BigInteger.class, (String)title, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).addJavadoc(javaDoc, new Object[0]).build();
    }

    public FieldSpec processBytesDataType(String javaDoc, BlueprintSchema schema, String alternativeName) {
        if (schema.getDataType() != BlueprintDatatype.bytes) {
            throw new IllegalArgumentException("Schema is not of type bytes");
        }
        String title = schema.getTitle() == null ? alternativeName : schema.getTitle();
        title = JavaFileUtil.firstLowerCase(JavaFileUtil.toCamelCase(title));
        return FieldSpec.builder(byte[].class, (String)title, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).addJavadoc(javaDoc, new Object[0]).build();
    }

    public FieldSpec processListDataType(String ns, String javaDoc, BlueprintSchema schema, String alternativeName) {
        if (schema.getDataType() != BlueprintDatatype.list) {
            throw new IllegalArgumentException("Schema is not of type list");
        }
        String title = schema.getTitle() == null ? alternativeName : schema.getTitle();
        TypeName fieldClass = this.getTypeNameForListParametrizedType(ns, schema);
        title = JavaFileUtil.firstLowerCase(JavaFileUtil.toCamelCase(title));
        return FieldSpec.builder((TypeName)fieldClass, (String)title, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).addJavadoc(javaDoc, new Object[0]).build();
    }

    public FieldSpec processOptionDataType(String ns, String javaDoc, BlueprintSchema schema, String alternativeName) {
        if (schema.getDataType() != BlueprintDatatype.option) {
            throw new IllegalArgumentException("Schema is not of type option");
        }
        String title = schema.getTitle() == null ? alternativeName : schema.getTitle();
        TypeName fieldClass = this.getTypeNameForOptionParametrizedType(ns, schema);
        title = JavaFileUtil.firstLowerCase(JavaFileUtil.toCamelCase(title));
        return FieldSpec.builder((TypeName)fieldClass, (String)title, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).addJavadoc(javaDoc, new Object[0]).build();
    }

    public FieldSpec processPairDataType(String ns, String javaDoc, BlueprintSchema schema, String alternativeName) {
        if (schema.getDataType() != BlueprintDatatype.pair) {
            throw new IllegalArgumentException("Schema is not of type pair");
        }
        String title = schema.getTitle() == null ? alternativeName : schema.getTitle();
        TypeName fieldClass = this.getTypeNameForPairParametrizedType(ns, schema);
        title = JavaFileUtil.firstLowerCase(JavaFileUtil.toCamelCase(title));
        return FieldSpec.builder((TypeName)fieldClass, (String)title, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).addJavadoc(javaDoc, new Object[0]).build();
    }

    private TypeName getTypeNameForListParametrizedType(String ns, BlueprintSchema field) {
        return ParameterizedTypeName.get((ClassName)ClassName.get((String)"java.util", (String)"List", (String[])new String[0]), (TypeName[])new TypeName[]{this.getInnerType(ns, field.getItems())});
    }

    private TypeName getTypeNameForMapParametrizedType(String ns, BlueprintSchema field) {
        return ParameterizedTypeName.get((ClassName)ClassName.get((String)"java.util", (String)"Map", (String[])new String[0]), (TypeName[])new TypeName[]{this.getInnerType(ns, field.getKeys()), this.getInnerType(ns, field.getValues())});
    }

    private TypeName getTypeNameForOptionParametrizedType(String ns, BlueprintSchema field) {
        List anyOfs = field.getAnyOf();
        if (anyOfs == null || anyOfs.size() != 2) {
            throw new IllegalArgumentException("Option type should have 2 anyOfs");
        }
        BlueprintSchema someSchema = anyOfs.stream().filter(s -> s.getTitle().equals("Some")).findFirst().orElse(null);
        if (someSchema == null) {
            throw new IllegalArgumentException("Option type should have a Some type");
        }
        if (someSchema.getFields().size() > 1) {
            throw new IllegalArgumentException("Option type should have only one field in Some type");
        }
        return ParameterizedTypeName.get((ClassName)ClassName.get((String)"java.util", (String)"Optional", (String[])new String[0]), (TypeName[])new TypeName[]{this.getInnerType(ns, (BlueprintSchema)someSchema.getFields().get(0))});
    }

    private TypeName getTypeNameForPairParametrizedType(String ns, BlueprintSchema schema) {
        BlueprintSchema left = schema.getLeft();
        BlueprintSchema right = schema.getRight();
        if (left == null || right == null) {
            throw new IllegalArgumentException("Pair type should have left and right fields");
        }
        return ParameterizedTypeName.get((ClassName)ClassName.get((String)"com.bloxbean.cardano.client.plutus.blueprint.type", (String)"Pair", (String[])new String[0]), (TypeName[])new TypeName[]{this.getInnerType(ns, left), this.getInnerType(ns, right)});
    }

    private TypeName getInnerType(String ns, BlueprintSchema items) {
        if (items.getDataType() == null) {
            ClassName typeName = this.fieldSpecProcessor.getInnerDatumClass(ns, items);
            return typeName;
        }
        BlueprintDatatype dataType = items.getDataType();
        switch (dataType) {
            case bytes: {
                return TypeName.get(byte[].class);
            }
            case integer: {
                return TypeName.get(BigInteger.class);
            }
            case string: {
                return TypeName.get(String.class);
            }
            case bool: {
                return TypeName.get(Boolean.class);
            }
            case list: {
                return this.getTypeNameForListParametrizedType(ns, items);
            }
            case map: {
                return this.getTypeNameForMapParametrizedType(ns, items);
            }
            case option: {
                return this.getTypeNameForOptionParametrizedType(ns, items);
            }
            case pair: {
                return this.getTypeNameForPairParametrizedType(ns, items);
            }
        }
        return TypeName.get(String.class);
    }

    public FieldSpec processBoolDataType(String javaDoc, BlueprintSchema schema, String alternativeName) {
        if (schema.getDataType() != BlueprintDatatype.bool) {
            throw new IllegalArgumentException("Schema is not of type boolean");
        }
        String title = schema.getTitle() == null ? alternativeName : schema.getTitle();
        title = JavaFileUtil.firstLowerCase(JavaFileUtil.toCamelCase(title));
        return FieldSpec.builder(Boolean.TYPE, (String)title, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).addJavadoc(javaDoc, new Object[0]).build();
    }

    public FieldSpec processStringDataType(String javaDoc, BlueprintSchema schema, String alternativeName) {
        if (schema.getDataType() != BlueprintDatatype.string) {
            throw new IllegalArgumentException("Schema is not of type string");
        }
        String title = schema.getTitle() == null ? alternativeName : schema.getTitle();
        title = JavaFileUtil.firstLowerCase(JavaFileUtil.toCamelCase(title));
        return FieldSpec.builder(String.class, (String)title, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).addJavadoc(javaDoc, new Object[0]).build();
    }

    public List<FieldSpec> processConstructorDataType(String ns, String javaDoc, BlueprintSchema schema, String className, String alternativeName) {
        ArrayList<FieldSpec> specs = new ArrayList<FieldSpec>();
        for (BlueprintSchema field : schema.getFields()) {
            if (field.getDataType() != null) {
                specs.addAll(this.fieldSpecProcessor.createFieldSpecForDataTypes(ns, javaDoc, List.of(field)));
                continue;
            }
            specs.add((FieldSpec)this.fieldSpecProcessor.createDatumFieldSpec((String)ns, (String)"", (BlueprintSchema)field, (String)field.getTitle())._1);
        }
        if (schema.getFields().isEmpty()) {
            specs.add(this.createEnumAndAddToFields(ns, schema, className));
        }
        return specs;
    }

    private FieldSpec createEnumAndAddToFields(String ns, BlueprintSchema schema, String className) {
        AnnotationSpec constrAnnotationBuilder = AnnotationSpec.builder(Constr.class).addMember("alternative", "$L", new Object[]{schema.getIndex()}).build();
        String fieldName = JavaFileUtil.firstUpperCase(schema.getTitle());
        TypeSpec enumConstr = TypeSpec.classBuilder((String)fieldName).addAnnotation(constrAnnotationBuilder).addModifiers(new Modifier[]{Modifier.PUBLIC}).build();
        String pkg = this.getPackage(ns);
        ClassName classIdentifier = ClassName.get((String)pkg, (String)enumConstr.name, (String[])new String[0]);
        return FieldSpec.builder((TypeName)classIdentifier, (String)fieldName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).addJavadoc("Index: " + schema.getIndex(), new Object[0]).build();
    }

    public FieldSpec processMapDataType(String ns, String javaDoc, BlueprintSchema schema, String className, String alternativeName) {
        if (schema.getDataType() != BlueprintDatatype.map) {
            throw new IllegalArgumentException("Schema is not of type map");
        }
        String title = schema.getTitle() == null ? alternativeName : schema.getTitle();
        TypeName fieldClass = this.getTypeNameForMapParametrizedType(ns, schema);
        title = JavaFileUtil.firstLowerCase(JavaFileUtil.toCamelCase(title));
        return FieldSpec.builder((TypeName)fieldClass, (String)title, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).addJavadoc(javaDoc, new Object[0]).build();
    }

    public FieldSpec processPlutusDataType(String javaDoc, BlueprintSchema schema, String alternativeName) {
        if (schema.getDataType() != null) {
            throw new IllegalArgumentException("Schema is not of type plutusdata");
        }
        String title = schema.getTitle() == null ? alternativeName : schema.getTitle();
        title = JavaFileUtil.firstLowerCase(JavaFileUtil.toCamelCase(title));
        return FieldSpec.builder(PlutusData.class, (String)title, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).addJavadoc(javaDoc, new Object[0]).build();
    }

    private String getPackage(String ns) {
        String pkg = ns != null && !ns.isEmpty() ? this.annotation.packageName() + "." + ns + ".model" : this.annotation.packageName() + ".model";
        return JavaFileUtil.toPackageNameFormat(pkg);
    }
}

