/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.annotation.processor;

import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import com.bloxbean.cardano.client.plutus.annotation.BasePlutusDataConverter;
import com.bloxbean.cardano.client.plutus.annotation.processor.ClassDefinitionGenerator;
import com.bloxbean.cardano.client.plutus.annotation.processor.CodeGenerator;
import com.bloxbean.cardano.client.plutus.annotation.processor.model.ClassDefinition;
import com.bloxbean.cardano.client.plutus.annotation.processor.model.Field;
import com.bloxbean.cardano.client.plutus.annotation.processor.model.FieldType;
import com.bloxbean.cardano.client.plutus.annotation.processor.model.JavaType;
import com.bloxbean.cardano.client.plutus.annotation.processor.model.Type;
import com.bloxbean.cardano.client.plutus.annotation.processor.util.JavaFileUtil;
import com.bloxbean.cardano.client.plutus.blueprint.type.Pair;
import com.bloxbean.cardano.client.plutus.spec.BigIntPlutusData;
import com.bloxbean.cardano.client.plutus.spec.BytesPlutusData;
import com.bloxbean.cardano.client.plutus.spec.ConstrPlutusData;
import com.bloxbean.cardano.client.plutus.spec.ListPlutusData;
import com.bloxbean.cardano.client.plutus.spec.MapPlutusData;
import com.bloxbean.cardano.client.util.HexUtil;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConverterCodeGenerator
implements CodeGenerator {
    private static final Logger log = LoggerFactory.getLogger(ConverterCodeGenerator.class);
    private ProcessingEnvironment processEnv;

    public ConverterCodeGenerator(ProcessingEnvironment processingEnvironment) {
        this.processEnv = processingEnvironment;
    }

    @Override
    public TypeSpec generate(ClassDefinition classDef) {
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)classDef.getConverterClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(BasePlutusDataConverter.class);
        MethodSpec toPlutusDataMethod = this.generateToPlutusDataMethod(classDef);
        MethodSpec fromPlutusDataMethod = this.generateFromPlutusDataMethod(classDef);
        return classBuilder.addJavadoc("Auto generated code. DO NOT MODIFY", new Object[0]).addMethod(toPlutusDataMethod).addMethod(fromPlutusDataMethod).addMethod(this.generateSerialize(classDef)).addMethod(this.generateSerializeToHex(classDef)).addMethod(this.generateDeserialize(classDef)).addMethod(this.generateDeserializeFromHex(classDef)).build();
    }

    public TypeSpec generateInterfaceConverter(ClassDefinition classDef, List<ClassDefinition> constructors) {
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)classDef.getConverterClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(BasePlutusDataConverter.class);
        constructors.sort(Comparator.comparingInt(ClassDefinition::getAlternative));
        String interfaceName = classDef.getDataClassName();
        String paramName = JavaFileUtil.firstLowerCase(interfaceName);
        ClassName interfaceTypeName = ClassName.get((String)classDef.getPackageName(), (String)interfaceName, (String[])new String[0]);
        MethodSpec.Builder toPlutusDataMethod = ConverterCodeGenerator.getInterfaceConverterToPlutusData(classDef, constructors, interfaceTypeName, paramName);
        MethodSpec.Builder fromPlutusDataMethod = ConverterCodeGenerator.getInterfaceConverterFromPlutusData(classDef, constructors);
        return classBuilder.addJavadoc("Auto generated code. DO NOT MODIFY", new Object[0]).addMethod(toPlutusDataMethod.build()).addMethod(fromPlutusDataMethod.build()).addMethod(this.generateSerialize(classDef)).addMethod(this.generateSerializeToHex(classDef)).addMethod(this.generateDeserialize(classDef)).addMethod(this.generateDeserializeFromHex(classDef)).build();
    }

    private static MethodSpec.Builder getInterfaceConverterFromPlutusData(ClassDefinition classDef, List<ClassDefinition> constructors) {
        ClassName className = ClassName.get((String)classDef.getPackageName(), (String)classDef.getDataClassName(), (String[])new String[0]);
        MethodSpec.Builder fromPlutusDataMethod = MethodSpec.methodBuilder((String)"fromPlutusData").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)className).addParameter(ConstrPlutusData.class, "constr", new Modifier[0]);
        for (ClassDefinition constructor : constructors) {
            String converterClassName = constructor.getConverterClassName();
            String converterPkgName = constructor.getConverterPackageName();
            ClassName constrConverterTypeName = ClassName.get((String)converterPkgName, (String)converterClassName, (String[])new String[0]);
            fromPlutusDataMethod.beginControlFlow("if(constr.getAlternative() == $L)", new Object[]{constructor.getAlternative()}).addStatement("return new $T().fromPlutusData(constr)", new Object[]{constrConverterTypeName}).endControlFlow();
        }
        fromPlutusDataMethod.addStatement("throw new $T(\"Invalid alternative: \" + constr.getAlternative())", new Object[]{CborRuntimeException.class});
        return fromPlutusDataMethod;
    }

    private static MethodSpec.Builder getInterfaceConverterToPlutusData(ClassDefinition classDef, List<ClassDefinition> constructors, ClassName interfaceTypeName, String paramName) {
        MethodSpec.Builder toPlutusDataMethod = MethodSpec.methodBuilder((String)"toPlutusData").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(ConstrPlutusData.class).addParameter((TypeName)interfaceTypeName, paramName, new Modifier[0]);
        toPlutusDataMethod.addStatement("$T.requireNonNull($L, \"$L cannot be null\")", new Object[]{Objects.class, paramName, paramName});
        for (ClassDefinition constructor : constructors) {
            String converterClassName = constructor.getConverterClassName();
            String converterPkgName = constructor.getConverterPackageName();
            ClassName constrConverterTypeName = ClassName.get((String)converterPkgName, (String)converterClassName, (String[])new String[0]);
            ClassName constrTypeName = ClassName.get((String)constructor.getPackageName(), (String)constructor.getDataClassName(), (String[])new String[0]);
            if (constructor.getFields().size() == 0) {
                toPlutusDataMethod.beginControlFlow("if($L instanceof $T)", new Object[]{paramName, ClassName.get((String)classDef.getPackageName(), (String)constructor.getDataClassName(), (String[])new String[0])}).addStatement("return new $T().toPlutusData(($T)$L)", new Object[]{ClassName.get((String)constructor.getPackageName(), (String)constructor.getDataClassName(), (String[])new String[0]), ClassName.get((String)constructor.getPackageName(), (String)constructor.getDataClassName(), (String[])new String[0]), paramName}).endControlFlow();
                continue;
            }
            toPlutusDataMethod.beginControlFlow("if($L instanceof $T)", new Object[]{paramName, constrTypeName}).addStatement("return new $T().toPlutusData(($T)$L)", new Object[]{constrConverterTypeName, constrTypeName, paramName}).endControlFlow();
        }
        toPlutusDataMethod.addCode("\n", new Object[0]);
        toPlutusDataMethod.addStatement("throw new $T(\"Unsupported type: \" + $L.getClass())", new Object[]{CborRuntimeException.class, paramName});
        return toPlutusDataMethod;
    }

    private MethodSpec generateSerializeToHex(ClassDefinition classDefinition) {
        TypeName objTypeName = this.bestGuess(classDefinition.getObjType());
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"serializeToHex").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addParameter(objTypeName, "obj", new Modifier[0]);
        CodeBlock body = CodeBlock.builder().addStatement("$T.requireNonNull(obj);", new Object[]{Objects.class}).addStatement("var constr = toPlutusData(obj)", new Object[0]).addStatement("return constr.serializeToHex()", new Object[0]).build();
        return methodBuilder.addCode(body).build();
    }

    private MethodSpec generateSerialize(ClassDefinition classDefinition) {
        TypeName objTypeName = this.bestGuess(classDefinition.getObjType());
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"serialize").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(byte[].class).addParameter(objTypeName, "obj", new Modifier[0]);
        CodeBlock body = CodeBlock.builder().addStatement("$T.requireNonNull(obj);", new Object[]{Objects.class}).beginControlFlow("try", new Object[0]).addStatement("var constr = toPlutusData(obj)", new Object[0]).addStatement("return $T.serialize(constr.serialize())", new Object[]{CborSerializationUtil.class}).nextControlFlow("catch ($T e)", new Object[]{Exception.class}).addStatement("throw new $T(e)", new Object[]{CborRuntimeException.class}).endControlFlow().build();
        return methodBuilder.addCode(body).build();
    }

    private MethodSpec generateDeserializeFromHex(ClassDefinition classDefinition) {
        TypeName objTypeName = this.bestGuess(classDefinition.getObjType());
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"deserialize").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(objTypeName).addParameter(String.class, "hex", new Modifier[0]);
        CodeBlock body = CodeBlock.builder().addStatement("$T.requireNonNull(hex);", new Object[]{Objects.class}).addStatement("var bytes = $T.decodeHexString(hex)", new Object[]{HexUtil.class}).addStatement("return deserialize(bytes)", new Object[0]).build();
        return methodBuilder.addCode(body).build();
    }

    private MethodSpec generateDeserialize(ClassDefinition classDefinition) {
        TypeName objTypeName = this.bestGuess(classDefinition.getObjType());
        MethodSpec.Builder serializeMethodBuilder = MethodSpec.methodBuilder((String)"deserialize").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(objTypeName).addParameter(byte[].class, "bytes", new Modifier[0]);
        CodeBlock body = CodeBlock.builder().addStatement("$T.requireNonNull(bytes);", new Object[]{Objects.class}).beginControlFlow("try", new Object[0]).addStatement("var di = $T.deserialize(bytes)", new Object[]{CborSerializationUtil.class}).addStatement("var constr = $T.deserialize(di)", new Object[]{ConstrPlutusData.class}).addStatement("return fromPlutusData(constr)", new Object[0]).nextControlFlow("catch ($T e)", new Object[]{Exception.class}).addStatement("throw new $T(e)", new Object[]{CborRuntimeException.class}).endControlFlow().build();
        return serializeMethodBuilder.addCode(body).build();
    }

    private MethodSpec generateToPlutusDataMethod(ClassDefinition classDef) {
        TypeName objTypeName = this.bestGuess(classDef.getObjType());
        MethodSpec.Builder serializeMethodBuilder = MethodSpec.methodBuilder((String)"toPlutusData").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(ConstrPlutusData.class).addParameter(objTypeName, "obj", new Modifier[0]);
        CodeBlock.Builder serializeBody = CodeBlock.builder().addStatement("$T constr = initConstr($L)", new Object[]{ConstrPlutusData.class, classDef.getAlternative()});
        for (Field field : classDef.getFields()) {
            CodeBlock codeBlock;
            switch (field.getFieldType().getType()) {
                case INTEGER: 
                case BYTES: 
                case STRING: {
                    codeBlock = CodeBlock.builder().add("//Field $L\n", new Object[]{field.getName()}).add(this.nullCheckStatement(field, this.fieldOrGetterName(field))).addStatement("constr.getData().add(toPlutusData(obj.$L))", new Object[]{this.fieldOrGetterName(field)}).add("\n", new Object[0]).build();
                    break;
                }
                case LIST: {
                    String outputListName = field.getName() + "ListPlutusData";
                    CodeBlock listCodeBlock = this.generateNestedListCode(field.getFieldType(), field.getName(), outputListName, "item", "obj." + this.fieldOrGetterName(field));
                    codeBlock = CodeBlock.builder().add("//Field $L\n", new Object[]{field.getName()}).add(this.nullCheckStatement(field, this.fieldOrGetterName(field))).add(listCodeBlock).addStatement("constr.getData().add($L)", new Object[]{outputListName}).add("\n", new Object[0]).build();
                    break;
                }
                case MAP: {
                    String outputMapName = field.getName() + "MapPlutusData";
                    codeBlock = CodeBlock.builder().add("//Field $L\n", new Object[]{field.getName()}).add(this.nullCheckStatement(field, this.fieldOrGetterName(field))).add(this.generateNestedMapCode(field.getFieldType(), outputMapName, "entry", "obj." + this.fieldOrGetterName(field))).addStatement("constr.getData().add($L)", new Object[]{outputMapName}).add("\n", new Object[0]).build();
                    break;
                }
                case PLUTUSDATA: {
                    codeBlock = CodeBlock.builder().add("//Field $L\n", new Object[]{field.getName()}).add(this.nullCheckStatement(field, this.fieldOrGetterName(field))).addStatement("constr.getData().add(obj.$L)", new Object[]{this.fieldOrGetterName(field)}).add("\n", new Object[0]).build();
                    break;
                }
                case OPTIONAL: {
                    codeBlock = this.generateOptionalSerializationCode(field);
                    break;
                }
                case PAIR: {
                    codeBlock = this.generatePairSerializationCode(field);
                    break;
                }
                case CONSTRUCTOR: {
                    ClassName converterClass = ClassDefinitionGenerator.getConverterClassFromField(field.getFieldType());
                    codeBlock = CodeBlock.builder().add("//Field $L\n", new Object[]{field.getName()}).beginControlFlow("if(obj.$L != null)", new Object[]{this.fieldOrGetterName(field)}).addStatement("constr.getData().add(new $T().toPlutusData(obj.$L))", new Object[]{converterClass, this.fieldOrGetterName(field)}).endControlFlow().build();
                    break;
                }
                case BOOL: {
                    codeBlock = CodeBlock.builder().add("//Field $L\n", new Object[]{field.getName()}).add(this.nullCheckStatement(field, this.fieldOrGetterName(field))).addStatement("constr.getData().add(toPlutusData(obj.$L))", new Object[]{this.fieldOrGetterName(field)}).add("\n", new Object[0]).build();
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported type : " + String.valueOf((Object)field.getFieldType().getType()));
                }
            }
            if (codeBlock == null) continue;
            serializeBody.add(codeBlock);
        }
        serializeBody.addStatement("return constr", new Object[0]);
        CodeBlock serializeBodyCodeBlock = serializeBody.build();
        return serializeMethodBuilder.addCode(serializeBodyCodeBlock).build();
    }

    private String toPlutusDataCodeBlock(FieldType itemType, String fieldOrGetterName) {
        switch (itemType.getType()) {
            case INTEGER: 
            case BYTES: 
            case STRING: 
            case BOOL: {
                return "toPlutusData(" + fieldOrGetterName + ")";
            }
        }
        ClassName converterClassName = ClassDefinitionGenerator.getConverterClassFromField(itemType);
        String converterClazz = converterClassName.packageName() + "." + converterClassName.simpleName();
        return String.format("new %s().toPlutusData(%s)", converterClazz, fieldOrGetterName);
    }

    private CodeBlock nullCheckStatement(Field field, String fieldOrGetterName) {
        CodeBlock.Builder nullCheckBuilder = CodeBlock.builder();
        nullCheckBuilder.addStatement("$T.requireNonNull(obj.$L, \"$L cannot be null\")", new Object[]{Objects.class, fieldOrGetterName, field.getName()});
        return nullCheckBuilder.build();
    }

    private CodeBlock nullCheckStatement(String fieldName, String fieldOrGetterName) {
        CodeBlock.Builder nullCheckBuilder = CodeBlock.builder();
        nullCheckBuilder.addStatement("$T.requireNonNull(obj.$L, \"$L cannot be null\")", new Object[]{Objects.class, fieldOrGetterName, fieldName});
        return nullCheckBuilder.build();
    }

    private CodeBlock generateNestedListCode(FieldType fieldType, String fieldName, String outputVarName, String loopVarName, String objectName) {
        FieldType genericType = fieldType.getGenericTypes().get(0);
        CodeBlock.Builder codeBlockBuilder = CodeBlock.builder();
        codeBlockBuilder.addStatement("$T $L = $T.builder().build()", new Object[]{ListPlutusData.class, outputVarName, ListPlutusData.class}).beginControlFlow("for(var $L: $L)", new Object[]{loopVarName, objectName});
        if (genericType.isList()) {
            String innerListName = fieldName + "_$inner";
            String innerLoopVarName = loopVarName + "_$inner";
            String innerOutputVarName = outputVarName + "_$inner";
            CodeBlock nestedListCodeBlock = this.generateNestedListCode(genericType, innerListName, innerOutputVarName, innerLoopVarName, loopVarName);
            codeBlockBuilder.add(nestedListCodeBlock).addStatement("$L.add($L)", new Object[]{outputVarName, innerOutputVarName});
        } else if (genericType.isMap()) {
            String innerLoopVarName = loopVarName + "_$inner";
            String innerOutputVarName = outputVarName + "_$inner";
            CodeBlock nestedMapCodeBlock = this.generateNestedMapCode(genericType, innerOutputVarName, innerLoopVarName, loopVarName);
            codeBlockBuilder.add(nestedMapCodeBlock).addStatement("$L.add($L)", new Object[]{outputVarName, innerOutputVarName});
        } else if (genericType.getType() == Type.OPTIONAL) {
            String returnVarName = loopVarName + "_$optional";
            CodeBlock optionalCodeBlock = this.generateNestedOptionalSerializationCode(genericType, loopVarName, returnVarName);
            codeBlockBuilder.add(optionalCodeBlock);
            codeBlockBuilder.addStatement("$L.add($L)", new Object[]{outputVarName, returnVarName});
        } else {
            codeBlockBuilder.addStatement("$L.add($L)", new Object[]{outputVarName, this.toPlutusDataCodeBlock(genericType, loopVarName)});
        }
        codeBlockBuilder.endControlFlow();
        return codeBlockBuilder.build();
    }

    private CodeBlock generateNestedMapCode(FieldType fieldType, String outputVarName, String entryVarName, String mapObjectName) {
        FieldType keyType = fieldType.getGenericTypes().get(0);
        FieldType valueType = fieldType.getGenericTypes().get(1);
        CodeBlock.Builder codeBlockBuilder = CodeBlock.builder();
        codeBlockBuilder.addStatement("$T $L = $T.builder().build()", new Object[]{MapPlutusData.class, outputVarName, MapPlutusData.class}).beginControlFlow("for(var $L: $L.entrySet())", new Object[]{entryVarName, mapObjectName});
        String keyOutputVarName = outputVarName + "_$key";
        String valueOutputVarName = outputVarName + "_$value";
        CodeBlock keyCodeBlock = this.generateCodeForKeyOrValue(keyType, entryVarName + "Key", keyOutputVarName, entryVarName + ".getKey()");
        CodeBlock valueCodeBlock = this.generateCodeForKeyOrValue(valueType, entryVarName + "Value", valueOutputVarName, entryVarName + ".getValue()");
        codeBlockBuilder.add(keyCodeBlock).add(valueCodeBlock);
        codeBlockBuilder.addStatement("$L.put($L, $L)", new Object[]{outputVarName, keyOutputVarName, valueOutputVarName}).endControlFlow();
        return codeBlockBuilder.build();
    }

    private CodeBlock generateCodeForKeyOrValue(FieldType type, String name, String outputVarName, String objName) {
        if (type.isList()) {
            return this.generateNestedListCode(type, name, outputVarName, name + "Item", objName);
        }
        if (type.isMap()) {
            return this.generateNestedMapCode(type, outputVarName, name + "Entry", objName);
        }
        if (type.getType() == Type.OPTIONAL) {
            CodeBlock optionalCodeBlock = this.generateNestedOptionalSerializationCode(type, name, outputVarName);
            CodeBlock codeBlock = CodeBlock.builder().addStatement("var $L = $L", new Object[]{name, objName}).add(optionalCodeBlock).build();
            return codeBlock;
        }
        return CodeBlock.builder().addStatement("var $L = $L", new Object[]{outputVarName, this.toPlutusDataCodeBlock(type, objName)}).build();
    }

    private CodeBlock generateOptionalSerializationCode(Field field) {
        FieldType fieldType = field.getFieldType();
        String fieldName = field.getName();
        String fieldOrGetterName = this.fieldOrGetterName(field);
        return this.generateOptionalSerializationCode(fieldType, fieldName, fieldOrGetterName);
    }

    private CodeBlock generateOptionalSerializationCode(FieldType fieldType, String fieldName, String fieldOrGetterName) {
        FieldType genericType = fieldType.getGenericTypes().get(0);
        CodeBlock nestedBlock = null;
        String nestedVarName = fieldName + "_$nested";
        if (!genericType.isCollection()) {
            nestedBlock = CodeBlock.builder().add("var $L=$L;", new Object[]{nestedVarName, this.toPlutusDataCodeBlock(fieldType.getGenericTypes().get(0), "obj." + fieldOrGetterName + ".get()")}).build();
        } else if (genericType.isList()) {
            nestedBlock = this.generateNestedListCode(genericType, fieldName, nestedVarName, "item", "obj." + fieldOrGetterName + ".get()");
        } else if (genericType.isMap()) {
            nestedBlock = this.generateNestedMapCode(genericType, nestedVarName, "entry", "obj." + fieldOrGetterName + ".get()");
        } else {
            throw new RuntimeException("Unsupported type " + String.valueOf(genericType));
        }
        return CodeBlock.builder().add("//Field $L\n", new Object[]{fieldName}).add(this.nullCheckStatement(fieldName, fieldOrGetterName)).beginControlFlow("if(obj.$L.isEmpty())", new Object[]{fieldOrGetterName}).addStatement("var $LConstr = $T.builder().alternative(1).data($T.of()).build()", new Object[]{fieldName, ConstrPlutusData.class, ListPlutusData.class}).addStatement("constr.getData().add($LConstr)", new Object[]{fieldName}).nextControlFlow("else", new Object[0]).add(nestedBlock).addStatement("var $LConstr = $T.builder().alternative(0).data($T.of($L)).build()", new Object[]{fieldName, ConstrPlutusData.class, ListPlutusData.class, nestedVarName}).addStatement("constr.getData().add($LConstr)", new Object[]{fieldName}).endControlFlow().add("\n", new Object[0]).build();
    }

    private CodeBlock generateNestedOptionalSerializationCode(FieldType fieldType, String varName, String outputVarName) {
        FieldType genericType = fieldType.getGenericTypes().get(0);
        CodeBlock nestedBlock = null;
        String nestedVarName = varName + "_$nested";
        if (!genericType.isCollection()) {
            nestedBlock = CodeBlock.builder().add("var $L=$L;", new Object[]{nestedVarName, this.toPlutusDataCodeBlock(fieldType.getGenericTypes().get(0), varName + ".get()")}).build();
        } else if (genericType.isList()) {
            String innerLoopVarName = varName + "_$inner";
            nestedBlock = this.generateNestedListCode(genericType, varName, nestedVarName, innerLoopVarName, varName + ".get()");
        } else if (genericType.isMap()) {
            String innerEntryVarName = varName + "_$inner";
            nestedBlock = this.generateNestedMapCode(genericType, nestedVarName, innerEntryVarName, varName + ".get()");
        } else {
            throw new RuntimeException("Unsupported type " + String.valueOf(genericType));
        }
        return CodeBlock.builder().add("//Field $L\n", new Object[]{varName}).addStatement("$T.requireNonNull($L, \"$L\")", new Object[]{Objects.class, varName, varName + " must not be null"}).addStatement("$T $L = null", new Object[]{ConstrPlutusData.class, outputVarName}).beginControlFlow("if($L.isEmpty())", new Object[]{varName}).addStatement("$L = $T.builder().alternative(1).data($T.of()).build()", new Object[]{outputVarName, ConstrPlutusData.class, ListPlutusData.class}).nextControlFlow("else", new Object[0]).add(nestedBlock).add("\n", new Object[0]).addStatement("$L = $T.builder().alternative(0).data($T.of($L)).build()", new Object[]{outputVarName, ConstrPlutusData.class, ListPlutusData.class, nestedVarName}).endControlFlow().add("\n", new Object[0]).build();
    }

    private CodeBlock generatePairSerializationCode(Field field) {
        FieldType fieldType = field.getFieldType();
        String fieldName = field.getName();
        String fieldOrGetterName = this.fieldOrGetterName(field);
        return this.generatePairSerializationCode(fieldType, fieldName, fieldOrGetterName);
    }

    private CodeBlock generatePairSerializationCode(FieldType fieldType, String fieldName, String fieldOrGetterName) {
        CodeBlock secondNestedBlock;
        CodeBlock firstNestedBlock;
        FieldType firstType = fieldType.getGenericTypes().get(0);
        FieldType secondType = fieldType.getGenericTypes().get(1);
        String firstNestedVarName = fieldName + "_$nested_first";
        String secondNestedVarName = fieldName + "_$nested_second";
        if (!firstType.isCollection()) {
            firstNestedBlock = CodeBlock.builder().add("var $L=$L;", new Object[]{firstNestedVarName, this.toPlutusDataCodeBlock(firstType, "obj." + fieldOrGetterName + ".getFirst()")}).build();
        } else if (firstType.isList()) {
            firstNestedBlock = this.generateNestedListCode(firstType, fieldName, firstNestedVarName, "item", "obj." + fieldOrGetterName + ".getFirst()");
        } else if (firstType.isMap()) {
            firstNestedBlock = this.generateNestedMapCode(firstType, firstNestedVarName, "entry", "obj." + fieldOrGetterName + ".getFirst()");
        } else {
            throw new RuntimeException("Unsupported type " + String.valueOf(firstType));
        }
        if (!secondType.isCollection()) {
            secondNestedBlock = CodeBlock.builder().add("var $L=$L;", new Object[]{secondNestedVarName, this.toPlutusDataCodeBlock(secondType, "obj." + fieldOrGetterName + ".getSecond()")}).build();
        } else if (secondType.isList()) {
            secondNestedBlock = this.generateNestedListCode(secondType, fieldName, secondNestedVarName, "item", "obj." + fieldOrGetterName + ".getSecond()");
        } else if (secondType.isMap()) {
            secondNestedBlock = this.generateNestedMapCode(secondType, secondNestedVarName, "entry", "obj." + fieldOrGetterName + ".getSecond()");
        } else {
            throw new RuntimeException("Unsupported type " + String.valueOf(secondType));
        }
        return CodeBlock.builder().add("//Field $L\n", new Object[]{fieldName}).add(this.nullCheckStatement(fieldName, fieldOrGetterName)).add(firstNestedBlock).add("\n", new Object[0]).add(secondNestedBlock).add("\n", new Object[0]).addStatement("$T $LPair = $T.builder().build()", new Object[]{ListPlutusData.class, fieldName, ListPlutusData.class}).addStatement("$LPair.add($L)", new Object[]{fieldName, firstNestedVarName}).addStatement("$LPair.add($L)", new Object[]{fieldName, secondNestedVarName}).addStatement("//Add the pair to the constructor", new Object[0]).addStatement("constr.getData().add($LPair)", new Object[]{fieldName}).add("\n", new Object[0]).build();
    }

    private MethodSpec generateFromPlutusDataMethod(ClassDefinition classDef) {
        TypeName objTypeName = this.bestGuess(classDef.getObjType());
        MethodSpec.Builder deserializeMethodBuilder = MethodSpec.methodBuilder((String)"fromPlutusData").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(objTypeName).addParameter(ConstrPlutusData.class, "constr", new Modifier[0]);
        if (classDef.isAbstract()) {
            ClassName implClassName = ClassName.get((String)classDef.getImplPackageName(), (String)classDef.getImplClassName(), (String[])new String[0]);
            objTypeName = implClassName;
        }
        CodeBlock initObjCodeBlock = CodeBlock.builder().addStatement("var obj = new $T()", new Object[]{objTypeName}).addStatement("var data = constr.getData()", new Object[0]).build();
        CodeBlock.Builder bodyCodeBlock = CodeBlock.builder();
        for (Field field : classDef.getFields()) {
            CodeBlock codeBlock = this.getDeserializeCodeBlockForField(field);
            if (codeBlock == null) continue;
            bodyCodeBlock.add("\n", new Object[0]);
            bodyCodeBlock.add(codeBlock);
            CodeBlock.Builder assignmentBlock = CodeBlock.builder();
            if (field.isHashGetter()) {
                assignmentBlock.addStatement("obj.$L($L)", new Object[]{this.setterName(field.getName()), field.getName()});
            } else {
                assignmentBlock.addStatement("obj.$L = $L", new Object[]{field.getName(), field.getName()});
            }
            bodyCodeBlock.add(assignmentBlock.build());
        }
        CodeBlock returnObjCodeBlock = CodeBlock.builder().addStatement("return obj", new Object[0]).build();
        return deserializeMethodBuilder.addCode(initObjCodeBlock).addCode(bodyCodeBlock.build()).addCode(returnObjCodeBlock).build();
    }

    private CodeBlock getDeserializeCodeBlockForField(Field field) {
        CodeBlock codeBlock = null;
        switch (field.getFieldType().getType()) {
            case INTEGER: {
                String getValueMethodName = ConverterCodeGenerator.getValueMethodNameForIntType(field.getFieldType());
                codeBlock = CodeBlock.builder().add("//Field $L\n", new Object[]{field.getName()}).addStatement("var $L = (($T)data.getPlutusDataList().get($L)).$L", new Object[]{field.getName(), BigIntPlutusData.class, field.getIndex(), getValueMethodName}).build();
                break;
            }
            case BYTES: {
                codeBlock = CodeBlock.builder().add("//Field $L\n", new Object[]{field.getName()}).addStatement("var $L = (($T)data.getPlutusDataList().get($L)).getValue()", new Object[]{field.getName(), BytesPlutusData.class, field.getIndex()}).build();
                break;
            }
            case STRING: {
                codeBlock = CodeBlock.builder().add("//Field $L\n", new Object[]{field.getName()}).addStatement("var $L = deserializeBytesToString((($T)data.getPlutusDataList().get($L)).getValue(), $S)", new Object[]{field.getName(), BytesPlutusData.class, field.getIndex(), field.getFieldType().getEncoding()}).build();
                break;
            }
            case LIST: {
                codeBlock = CodeBlock.builder().add("//Field $L\n", new Object[]{field.getName()}).addStatement("var $LList = (ListPlutusData)data.getPlutusDataList().get($L)", new Object[]{field.getName(), field.getIndex()}).add(this.generateListDeserializeCode(field.getFieldType(), field.getName(), field.getName() + "List", "item")).build();
                break;
            }
            case MAP: {
                codeBlock = CodeBlock.builder().add("//Field $L\n", new Object[]{field.getName()}).addStatement("var $LMap = (MapPlutusData)data.getPlutusDataList().get($L)", new Object[]{field.getName(), field.getIndex()}).add(this.generateMapDeserializeCode(field.getFieldType(), field.getName(), field.getName() + "Map", "entry")).build();
                break;
            }
            case PLUTUSDATA: {
                codeBlock = CodeBlock.builder().add("//Field $L\n", new Object[]{field.getName()}).add("var $L = data.getPlutusDataList().get($L);\n", new Object[]{field.getName(), field.getIndex()}).build();
                break;
            }
            case OPTIONAL: {
                codeBlock = this.generateOptionalDeserializationCode(field);
                break;
            }
            case PAIR: {
                codeBlock = this.generatePairDeserializationCode(field);
                break;
            }
            case CONSTRUCTOR: {
                TypeName fieldTypeName = this.bestGuess(field.getFieldType().getJavaType().getName());
                ClassName converterClazz = ClassDefinitionGenerator.getConverterClassFromField(field.getFieldType());
                codeBlock = CodeBlock.builder().add("//Field $L\n", new Object[]{field.getName()}).addStatement("$T $L = new $T().fromPlutusData((($T)data.getPlutusDataList().get($L)))", new Object[]{fieldTypeName, field.getName(), converterClazz, ConstrPlutusData.class, field.getIndex()}).build();
                break;
            }
            case BOOL: {
                codeBlock = CodeBlock.builder().add("//Field $L\n", new Object[]{field.getName()}).add("$T $L = null;\n", new Object[]{Boolean.class, field.getName()}).addStatement("var $LConstr = (($T)data.getPlutusDataList().get($L))", new Object[]{field.getName(), ConstrPlutusData.class, field.getIndex()}).beginControlFlow("if($LConstr.getAlternative() == 0)", new Object[]{field.getName()}).addStatement("$L = false", new Object[]{field.getName()}).nextControlFlow("else", new Object[0]).addStatement("$L = true", new Object[]{field.getName()}).endControlFlow().add("\n", new Object[0]).build();
                break;
            }
            default: {
                throw new RuntimeException("Unsupported type : " + String.valueOf((Object)field.getFieldType().getType()));
            }
        }
        return codeBlock;
    }

    private CodeBlock generateListDeserializeCode(FieldType fieldType, String fieldName, String pdListName, String itemVarName) {
        FieldType genericType = fieldType.getGenericTypes().get(0);
        CodeBlock.Builder codeBlockBuilder = CodeBlock.builder();
        codeBlockBuilder.addStatement("$L $L = new $T<>()", new Object[]{fieldType.getFqTypeName(), fieldName, ArrayList.class}).beginControlFlow("for(var $L: (($T)$L).getPlutusDataList())", new Object[]{itemVarName, ListPlutusData.class, pdListName});
        if (genericType.isList()) {
            String innerListName = fieldName + "_$inner";
            String innerItemVarName = itemVarName + "_$inner";
            CodeBlock innerListDeserializeCodeBlock = this.generateListDeserializeCode(genericType, innerListName, itemVarName, innerItemVarName);
            codeBlockBuilder.add(innerListDeserializeCodeBlock).addStatement("$L.add($L)", new Object[]{fieldName, innerListName});
        } else if (genericType.isMap()) {
            String innerMapName = fieldName + "_$inner";
            String innerEntryVarName = itemVarName + "_$inner";
            CodeBlock innerMapDeserializeCodeBlock = this.generateMapDeserializeCode(genericType, innerMapName, itemVarName, innerEntryVarName);
            codeBlockBuilder.add(innerMapDeserializeCodeBlock).addStatement("$L.add($L)", new Object[]{fieldName, innerMapName});
        } else if (genericType.getType() == Type.OPTIONAL) {
            String returnVarName = itemVarName + "_$optional";
            String innerItemVarName = itemVarName + "_$inner";
            codeBlockBuilder.addStatement("var $L = ($T)$L", new Object[]{innerItemVarName, ConstrPlutusData.class, itemVarName});
            CodeBlock optionalCodeBlock = this.generateNestedOptionalDeserializationCode(genericType, innerItemVarName, returnVarName);
            codeBlockBuilder.add(optionalCodeBlock);
            codeBlockBuilder.addStatement("$L.add($L)", new Object[]{fieldName, returnVarName});
        } else {
            codeBlockBuilder.addStatement("var o = $L", new Object[]{this.fromPlutusDataToObj(genericType, itemVarName)}).addStatement("$L.add(o)", new Object[]{fieldName});
        }
        codeBlockBuilder.endControlFlow();
        return codeBlockBuilder.build();
    }

    private CodeBlock generateMapDeserializeCode(FieldType fieldType, String fieldName, String pdMapName, String entryVarName) {
        FieldType keyType = fieldType.getGenericTypes().get(0);
        FieldType valueType = fieldType.getGenericTypes().get(1);
        CodeBlock.Builder codeBlockBuilder = CodeBlock.builder();
        codeBlockBuilder.addStatement("$L $L = new $T<>()", new Object[]{fieldType.getFqTypeName(), fieldName, LinkedHashMap.class}).beginControlFlow("for(var $L: (($T)$L).getMap().entrySet())", new Object[]{entryVarName, MapPlutusData.class, pdMapName});
        String innerEntryVarName = entryVarName + "_$inner";
        String keyOutputVarName = fieldName + "Key";
        String valueOutputVarName = fieldName + "Value";
        CodeBlock keyDeserializeCodeBlock = this.generateDeserializeCodeBlock(keyType, keyOutputVarName, entryVarName + ".getKey()", innerEntryVarName + "_$key");
        CodeBlock valueDeserializeCodeBlock = this.generateDeserializeCodeBlock(valueType, valueOutputVarName, entryVarName + ".getValue()", innerEntryVarName + "_$value");
        codeBlockBuilder.add(keyDeserializeCodeBlock).add(valueDeserializeCodeBlock).addStatement("$L.put($L, $L)", new Object[]{fieldName, keyOutputVarName, valueOutputVarName}).endControlFlow();
        return codeBlockBuilder.build();
    }

    private CodeBlock generateDeserializeCodeBlock(FieldType type, String fieldName, String pdName, String itemVarName) {
        if (type.isList()) {
            return this.generateListDeserializeCode(type, fieldName, pdName, itemVarName);
        }
        if (type.isMap()) {
            return this.generateMapDeserializeCode(type, fieldName, pdName, itemVarName);
        }
        if (type.getType() == Type.OPTIONAL) {
            CodeBlock optionalCodeBlock = this.generateNestedOptionalDeserializationCode(type, itemVarName, fieldName);
            CodeBlock codeBlock = CodeBlock.builder().addStatement("var $L = ($T)$L", new Object[]{itemVarName, ConstrPlutusData.class, pdName}).add(optionalCodeBlock).build();
            return codeBlock;
        }
        return CodeBlock.builder().addStatement("var $L = $L", new Object[]{fieldName, this.fromPlutusDataToObj(type, pdName)}).build();
    }

    private CodeBlock generateOptionalDeserializationCode(Field field) {
        CodeBlock nestedBlock = null;
        String nestedVarName = field.getName() + "_$nested";
        FieldType genericType = field.getFieldType().getGenericTypes().get(0);
        nestedBlock = genericType.isList() ? this.generateListDeserializeCode(genericType, nestedVarName, field.getName() + "PlutusData", "item") : (genericType.isMap() ? this.generateMapDeserializeCode(genericType, nestedVarName, field.getName() + "PlutusData", "entry") : CodeBlock.builder().addStatement("var $L=$L;", new Object[]{nestedVarName, this.fromPlutusDataToObj(field.getFieldType().getGenericTypes().get(0), field.getName() + "PlutusData")}).build());
        return CodeBlock.builder().add("//Field $L\n", new Object[]{field.getName()}).add("$L $L = null;\n", new Object[]{field.getFieldType().getFqTypeName(), field.getName()}).addStatement("var $LConstr = (ConstrPlutusData)data.getPlutusDataList().get($L)", new Object[]{field.getName(), field.getIndex()}).beginControlFlow("if($LConstr.getAlternative() == 1)", new Object[]{field.getName()}).addStatement("$L = $T.empty()", new Object[]{field.getName(), Optional.class}).nextControlFlow("else", new Object[0]).addStatement("var $LPlutusData = $LConstr.getData().getPlutusDataList().get(0)", new Object[]{field.getName(), field.getName()}).add(nestedBlock).addStatement("$L = Optional.ofNullable($L)", new Object[]{field.getName(), nestedVarName}).endControlFlow().add("\n", new Object[0]).build();
    }

    private CodeBlock generateNestedOptionalDeserializationCode(FieldType fieldType, String varName, String outputVarName) {
        CodeBlock nestedBlock = null;
        String nestedVarName = varName + "_$nested";
        FieldType genericType = fieldType.getGenericTypes().get(0);
        if (genericType.isList()) {
            String innerVarName = varName + "_$inner";
            nestedBlock = this.generateListDeserializeCode(genericType, nestedVarName, varName + "PlutusData", innerVarName);
        } else if (genericType.isMap()) {
            String innerEntryName = varName + "_$inner";
            nestedBlock = this.generateMapDeserializeCode(genericType, nestedVarName, varName + "PlutusData", innerEntryName);
        } else {
            nestedBlock = CodeBlock.builder().addStatement("var $L=$L;", new Object[]{nestedVarName, this.fromPlutusDataToObj(fieldType.getGenericTypes().get(0), varName + "PlutusData")}).build();
        }
        return CodeBlock.builder().add("//Field $L\n", new Object[]{varName}).add("$L $L = null;\n", new Object[]{fieldType.getFqTypeName(), outputVarName}).beginControlFlow("if($L.getAlternative() == 1)", new Object[]{varName}).addStatement("$L = $T.empty()", new Object[]{outputVarName, Optional.class}).nextControlFlow("else", new Object[0]).addStatement("var $LPlutusData = $L.getData().getPlutusDataList().get(0)", new Object[]{varName, varName}).add(nestedBlock).addStatement("$L = Optional.ofNullable($L)", new Object[]{outputVarName, nestedVarName}).endControlFlow().add("\n", new Object[0]).build();
    }

    private CodeBlock generatePairDeserializationCode(Field field) {
        CodeBlock firstNestedBlock = null;
        CodeBlock secondNestedBlock = null;
        String firstNestedVarName = field.getName() + "_$nested_first";
        String secondNestedVarName = field.getName() + "_$nested_second";
        FieldType firstType = field.getFieldType().getGenericTypes().get(0);
        FieldType secondType = field.getFieldType().getGenericTypes().get(1);
        firstNestedBlock = firstType.isList() ? this.generateListDeserializeCode(firstType, firstNestedVarName, field.getName() + "PlutusDataFirst", "item") : (firstType.isMap() ? this.generateMapDeserializeCode(firstType, firstNestedVarName, field.getName() + "PlutusDataFirst", "entry") : CodeBlock.builder().addStatement("var $L=$L;", new Object[]{firstNestedVarName, this.fromPlutusDataToObj(firstType, field.getName() + "PlutusDataFirst")}).build());
        secondNestedBlock = secondType.isList() ? this.generateListDeserializeCode(secondType, secondNestedVarName, field.getName() + "PlutusDataSecond", "item") : (secondType.isMap() ? this.generateMapDeserializeCode(secondType, secondNestedVarName, field.getName() + "PlutusDataSecond", "entry") : CodeBlock.builder().addStatement("var $L=$L;", new Object[]{secondNestedVarName, this.fromPlutusDataToObj(secondType, field.getName() + "PlutusDataSecond")}).build());
        return CodeBlock.builder().add("//Field $L\n", new Object[]{field.getName()}).addStatement("var $LList = (ListPlutusData)data.getPlutusDataList().get($L)", new Object[]{field.getName(), field.getIndex()}).addStatement("var $LPlutusDataFirst = $LList.getPlutusDataList().get(0)", new Object[]{field.getName(), field.getName()}).addStatement("var $LPlutusDataSecond = $LList.getPlutusDataList().get(1)", new Object[]{field.getName(), field.getName()}).add(firstNestedBlock).add("\n", new Object[0]).add(secondNestedBlock).add("\n", new Object[0]).addStatement("var $L = new $T($L, $L)", new Object[]{field.getName(), Pair.class, firstNestedVarName, secondNestedVarName}).add("\n", new Object[0]).build();
    }

    private String fromPlutusDataToObj(FieldType itemType, String fieldName) {
        switch (itemType.getType()) {
            case INTEGER: {
                String getValueMethodName = ConverterCodeGenerator.getValueMethodNameForIntType(itemType);
                if (itemType.getJavaType() == JavaType.INT || itemType.getJavaType() == JavaType.INTEGER) {
                    return String.format("plutusDataToInteger(%s)", fieldName);
                }
                if (itemType.getJavaType() == JavaType.LONG || itemType.getJavaType() == JavaType.LONG_OBJECT) {
                    return String.format("plutusDataToLong(%s)", fieldName);
                }
                if (itemType.getJavaType() != JavaType.BIGINTEGER) break;
                return String.format("plutusDataToBigInteger(%s)", fieldName);
            }
            case BYTES: {
                return String.format("plutusDataToBytes(%s)", fieldName);
            }
            case STRING: {
                if (itemType.getEncoding() == null) {
                    return String.format("plutusDataToString(%s, null)", fieldName);
                }
                return String.format("plutusDataToString(%s, \"%s\")", fieldName, itemType.getEncoding());
            }
            case BOOL: {
                return String.format("plutusDataToBoolean(%s)", fieldName);
            }
            default: {
                ClassName converterClassName = ClassDefinitionGenerator.getConverterClassFromField(itemType);
                String converterClazz = converterClassName.packageName() + "." + converterClassName.simpleName();
                return String.format("new %s().fromPlutusData((ConstrPlutusData)%s)", converterClazz, fieldName);
            }
        }
        return "";
    }

    private static String getValueMethodNameForIntType(FieldType fieldType) {
        String getValueMethodName = "getValue()";
        if (fieldType.getJavaType() == JavaType.INT || fieldType.getJavaType() == JavaType.INTEGER) {
            getValueMethodName = "getValue().intValue()";
        } else if (fieldType.getJavaType() == JavaType.LONG || fieldType.getJavaType() == JavaType.LONG_OBJECT) {
            getValueMethodName = "getValue().longValue()";
        }
        return getValueMethodName;
    }

    private String fieldOrGetterName(Field field) {
        if (field.isHashGetter()) {
            return field.getGetterName() + "()";
        }
        return field.getName();
    }

    private String setterName(String fieldName) {
        return "set" + this.capitalize(fieldName);
    }

    private String capitalize(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private TypeName bestGuess(String name) {
        if ("int".equals(name)) {
            return ClassName.get(Integer.class);
        }
        if ("long".equals(name)) {
            return ClassName.get(Long.class);
        }
        if ("byte[]".equals(name)) {
            return ArrayTypeName.of((TypeName)TypeName.BYTE);
        }
        return ClassName.bestGuess((String)name);
    }

    public Optional<TypeSpec> generateEnumConverter(ClassDefinition classDefinition) {
        if (!classDefinition.isEnum()) {
            return Optional.empty();
        }
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)classDefinition.getConverterClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(BasePlutusDataConverter.class);
        ClassName enumClassName = ClassName.get((String)classDefinition.getPackageName(), (String)classDefinition.getDataClassName(), (String[])new String[0]);
        List<String> enumConstants = classDefinition.getEnumValues();
        String parameterName = JavaFileUtil.firstLowerCase(enumClassName.simpleName());
        MethodSpec.Builder toPlutusDataMethodBuilder = ConverterCodeGenerator.getEnumToPlutusData(enumClassName, parameterName, enumConstants);
        MethodSpec.Builder fromPlutusDataMethodBuilder = ConverterCodeGenerator.getEnumFromPlutusData(enumClassName, enumConstants);
        TypeSpec typeSpec = classBuilder.addJavadoc("Auto generated code. DO NOT MODIFY", new Object[0]).addMethod(toPlutusDataMethodBuilder.build()).addMethod(fromPlutusDataMethodBuilder.build()).addMethod(this.generateSerialize(classDefinition)).addMethod(this.generateSerializeToHex(classDefinition)).addMethod(this.generateDeserialize(classDefinition)).addMethod(this.generateDeserializeFromHex(classDefinition)).build();
        return Optional.of(typeSpec);
    }

    private static MethodSpec.Builder getEnumFromPlutusData(ClassName enumClassName, List<String> enumConstants) {
        MethodSpec.Builder fromPlutusDataMethodBuilder = MethodSpec.methodBuilder((String)"fromPlutusData").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)enumClassName).addParameter(ConstrPlutusData.class, "constr", new Modifier[0]);
        fromPlutusDataMethodBuilder.addStatement("var data = constr.getData()", new Object[0]);
        for (int i = 0; i < enumConstants.size(); ++i) {
            String enumConstant = enumConstants.get(i);
            fromPlutusDataMethodBuilder.beginControlFlow("if(constr.getAlternative() == $L)", new Object[]{i}).addStatement("return $T.$L", new Object[]{enumClassName, enumConstant}).endControlFlow();
        }
        fromPlutusDataMethodBuilder.addStatement("throw new $T($S + constr.getAlternative())", new Object[]{IllegalArgumentException.class, "Invalid alternative : "});
        return fromPlutusDataMethodBuilder;
    }

    private static MethodSpec.Builder getEnumToPlutusData(ClassName enumClassName, String parameterName, List<String> enumConstants) {
        MethodSpec.Builder toPlutusDataMethodBuilder = MethodSpec.methodBuilder((String)"toPlutusData").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(ConstrPlutusData.class).addParameter((TypeName)enumClassName, parameterName, new Modifier[0]);
        for (int i = 0; i < enumConstants.size(); ++i) {
            String enumConstant = enumConstants.get(i);
            toPlutusDataMethodBuilder.beginControlFlow("if($L == $T.$L)", new Object[]{parameterName, enumClassName, enumConstant}).addStatement("return $T.builder().alternative($L).data($T.of()).build()", new Object[]{ConstrPlutusData.class, i, ListPlutusData.class});
            toPlutusDataMethodBuilder.endControlFlow();
        }
        toPlutusDataMethodBuilder.addStatement("throw new $T($S + $L)", new Object[]{IllegalArgumentException.class, "Invalid enum value : ", parameterName});
        return toPlutusDataMethodBuilder;
    }
}

