/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.annotation.processor.blueprint;

import com.bloxbean.cardano.client.address.AddressProvider;
import com.bloxbean.cardano.client.common.model.Network;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.plutus.annotation.Blueprint;
import com.bloxbean.cardano.client.plutus.annotation.ExtendWith;
import com.bloxbean.cardano.client.plutus.annotation.processor.blueprint.FieldSpecProcessor;
import com.bloxbean.cardano.client.plutus.annotation.processor.util.CodeGenUtil;
import com.bloxbean.cardano.client.plutus.annotation.processor.util.JavaFileUtil;
import com.bloxbean.cardano.client.plutus.blueprint.PlutusBlueprintUtil;
import com.bloxbean.cardano.client.plutus.blueprint.model.BlueprintDatum;
import com.bloxbean.cardano.client.plutus.blueprint.model.BlueprintSchema;
import com.bloxbean.cardano.client.plutus.blueprint.model.PlutusVersion;
import com.bloxbean.cardano.client.plutus.blueprint.model.Validator;
import com.bloxbean.cardano.client.plutus.spec.PlutusScript;
import com.bloxbean.cardano.client.quicktx.blueprint.extender.AbstractValidatorExtender;
import com.bloxbean.cardano.client.util.HexUtil;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public class ValidatorProcessor {
    private final Blueprint annotation;
    private final ExtendWith extendWith;
    private final ProcessingEnvironment processingEnv;
    private final FieldSpecProcessor fieldSpecProcessor;
    private final String VALIDATOR_CLASS_SUFFIX = "Validator";

    public ValidatorProcessor(Blueprint annotation, ExtendWith extendWith, ProcessingEnvironment processingEnv) {
        this.annotation = annotation;
        this.extendWith = extendWith;
        this.processingEnv = processingEnv;
        this.fieldSpecProcessor = new FieldSpecProcessor(annotation, processingEnv);
    }

    public void processValidator(Validator validator, PlutusVersion plutusVersion) {
        String[] titleTokens = validator.getTitle().split("\\.");
        String pkgSuffix = null;
        if (titleTokens.length > 1) {
            pkgSuffix = titleTokens[0];
        }
        String validatorName = titleTokens[titleTokens.length - 1];
        Object packageName = this.annotation.packageName();
        if (pkgSuffix != null) {
            packageName = (String)packageName + "." + pkgSuffix;
        }
        packageName = JavaFileUtil.toPackageNameFormat((String)packageName);
        String title = validatorName;
        title = JavaFileUtil.toCamelCase(title);
        List<FieldSpec> metaFields = ValidatorProcessor.getFieldSpecsForValidator(validator);
        FieldSpec networkField = FieldSpec.builder(Network.class, (String)"network", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
        FieldSpec scriptAddrField = FieldSpec.builder(String.class, (String)"scriptAddress", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
        FieldSpec plutusScriptField = FieldSpec.builder(PlutusScript.class, (String)"plutusScript", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
        boolean isParameterizedValidator = ValidatorProcessor.isParameterizedValidator(validator);
        FieldSpec applyParamCompiledCodeField = null;
        FieldSpec applyParamHashField = null;
        MethodSpec applyParamCompiledCodeGetter = null;
        MethodSpec applyParamHashGetter = null;
        if (isParameterizedValidator) {
            applyParamCompiledCodeField = FieldSpec.builder(String.class, (String)"applyParamCompiledCode", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
            applyParamHashField = FieldSpec.builder(String.class, (String)"applyParamHash", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
            applyParamCompiledCodeGetter = this.getApplyParamCompiledCodeGetterMethodSpec();
            applyParamHashGetter = this.getApplyParamHashGetterMethodSpec();
        }
        ArrayList<FieldSpec> fields = new ArrayList<FieldSpec>();
        if (validator.getRedeemer() != null && validator.getRedeemer().getSchema() != null && validator.getRedeemer().getSchema().getRef() == null) {
            BlueprintSchema redeemerSchema = validator.getRedeemer().getSchema();
            if (redeemerSchema.getTitle() == null) {
                redeemerSchema.setTitle(validator.getRedeemer().getTitle());
            }
            this.fieldSpecProcessor.createDatumClass(pkgSuffix, redeemerSchema);
        }
        if (validator.getDatum() != null && validator.getDatum().getSchema() != null && validator.getDatum().getSchema().getRef() == null) {
            BlueprintSchema datumSchema = validator.getDatum().getSchema();
            if (datumSchema.getTitle() == null) {
                datumSchema.setTitle(validator.getDatum().getTitle());
            }
            this.fieldSpecProcessor.createDatumClass(pkgSuffix, datumSchema);
        }
        if (validator.getParameters() != null && validator.getParameters().size() > 0) {
            for (BlueprintDatum parameter : validator.getParameters()) {
                if (parameter.getSchema() == null || parameter.getSchema().getRef() != null) continue;
                BlueprintSchema parameterSchema = parameter.getSchema();
                if (parameterSchema.getTitle() == null) {
                    parameterSchema.setTitle(parameter.getTitle());
                }
                this.fieldSpecProcessor.createDatumClass(pkgSuffix, parameterSchema);
            }
        }
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        methods.addAll(CodeGenUtil.createMethodSpecsForGetterSetters(fields, false));
        methods.addAll(CodeGenUtil.createMethodSpecsForGetterSetters(List.of(networkField), false));
        methods.add(this.getScriptAddressMethodSpec(plutusVersion));
        methods.add(this.getPlutusScriptMethodSpec(plutusVersion, isParameterizedValidator));
        if (isParameterizedValidator) {
            methods.add(applyParamCompiledCodeGetter);
            methods.add(applyParamHashGetter);
        }
        String validatorClassName = title + "Validator";
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)validatorClassName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Auto generated code. DO NOT MODIFY", new Object[0]).addMethod(this.getConstructorMethodSpec(isParameterizedValidator)).addFields(metaFields).addField(networkField).addField(scriptAddrField).addFields(fields).addField(plutusScriptField);
        if (isParameterizedValidator) {
            builder.addField(applyParamCompiledCodeField);
            builder.addField(applyParamHashField);
        }
        builder.addMethods(methods);
        if (this.extendWith != null) {
            List<? extends TypeMirror> extendWithTypeMirros = this.getExtendWithValues(this.extendWith);
            ClassName validatorTypeName = ClassName.get((String)packageName, (String)validatorClassName, (String[])new String[0]);
            for (TypeMirror typeMirror : extendWithTypeMirros) {
                TypeElement extendWithTypeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
                ClassName extendWithInterface = ClassName.get((TypeElement)extendWithTypeElement);
                ParameterizedTypeName parameterizedInterface = ParameterizedTypeName.get((ClassName)extendWithInterface, (TypeName[])new TypeName[]{validatorTypeName});
                builder.addSuperinterface((TypeName)parameterizedInterface);
            }
            ClassName abstractExtenderClass = ClassName.get(AbstractValidatorExtender.class);
            ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)abstractExtenderClass, (TypeName[])new TypeName[]{validatorTypeName});
            builder.superclass((TypeName)parameterizedTypeName);
        }
        TypeSpec build = builder.build();
        try {
            JavaFileUtil.createJavaFile((String)packageName, build, validatorClassName, this.processingEnv);
        }
        catch (Exception e) {
            this.error(null, "Error creating validator class : %s", e.getMessage());
        }
    }

    private MethodSpec getConstructorMethodSpec(boolean isParameterizedValidator) {
        if (isParameterizedValidator) {
            MethodSpec constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Network.class, "network", new Modifier[0]).addParameter(String.class, "applyParamCompiledCode", new Modifier[0]).addStatement("this.network = network", new Object[0]).addStatement("this.applyParamCompiledCode = applyParamCompiledCode", new Object[0]).build();
            return constructor;
        }
        MethodSpec constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Network.class, "network", new Modifier[0]).addStatement("this.network = network", new Object[0]).build();
        return constructor;
    }

    private MethodSpec getScriptAddressMethodSpec(PlutusVersion plutusVersion) {
        MethodSpec getScriptAddress = MethodSpec.methodBuilder((String)"getScriptAddress").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addJavadoc("Returns the address of the validator script", new Object[0]).beginControlFlow("if(scriptAddress == null)", new Object[0]).addStatement("var script = getPlutusScript()", new Object[0]).addStatement("scriptAddress = $T.getEntAddress(script, network).toBech32()", new Object[]{AddressProvider.class}).endControlFlow().addStatement("return scriptAddress", new Object[0]).build();
        return getScriptAddress;
    }

    private MethodSpec getPlutusScriptMethodSpec(PlutusVersion plutusVersion, boolean isParameterizedValidator) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getPlutusScript").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(PlutusScript.class);
        if (isParameterizedValidator) {
            builder.beginControlFlow("if (plutusScript == null)", new Object[0]);
            builder.addStatement("plutusScript = $T.getPlutusScriptFromCompiledCode(this.applyParamCompiledCode, $T.$L)", new Object[]{PlutusBlueprintUtil.class, plutusVersion.getClass(), plutusVersion});
            builder.endControlFlow();
            builder.addStatement("return plutusScript", new Object[0]);
        } else {
            builder.beginControlFlow("if (plutusScript == null)", new Object[0]);
            builder.addStatement("plutusScript = $T.getPlutusScriptFromCompiledCode(COMPILED_CODE, $T.$L)", new Object[]{PlutusBlueprintUtil.class, plutusVersion.getClass(), plutusVersion});
            builder.endControlFlow();
            builder.addStatement("return plutusScript", new Object[0]);
        }
        return builder.build();
    }

    private MethodSpec getApplyParamCompiledCodeGetterMethodSpec() {
        MethodSpec getApplyParamCompiledCode = MethodSpec.methodBuilder((String)"getApplyParamCompiledCode").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return applyParamCompiledCode", new Object[0]).build();
        return getApplyParamCompiledCode;
    }

    private MethodSpec getApplyParamHashGetterMethodSpec() {
        MethodSpec getApplyParamHash = MethodSpec.methodBuilder((String)"getApplyParamHash").addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Returns the hash of the script after applying the parameters\n", new Object[0]).addJavadoc("@throws CborRuntimeException if there is an error in getting the hash", new Object[0]).returns(String.class).beginControlFlow("if (applyParamHash == null)", new Object[0]).beginControlFlow("try", new Object[0]).addStatement("applyParamHash = $T.encodeHexString(getPlutusScript().getScriptHash())", new Object[]{HexUtil.class}).nextControlFlow("catch ($T e)", new Object[]{CborSerializationException.class}).addStatement("throw new $T(\"Error getting hash from compiled code\", e)", new Object[]{CborRuntimeException.class}).endControlFlow().endControlFlow().addStatement("return applyParamHash", new Object[0]).build();
        return getApplyParamHash;
    }

    public static List<FieldSpec> getFieldSpecsForValidator(Validator validator) {
        ArrayList<FieldSpec> fields = new ArrayList<FieldSpec>();
        fields.add(FieldSpec.builder(String.class, (String)"TITLE", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).initializer("$S", new Object[]{validator.getTitle()}).build());
        fields.add(FieldSpec.builder(String.class, (String)"DESCRIPTION", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).initializer("$S", new Object[]{validator.getDescription()}).build());
        fields.add(FieldSpec.builder(String.class, (String)"COMPILED_CODE", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).initializer("$S", new Object[]{validator.getCompiledCode()}).build());
        fields.add(FieldSpec.builder(String.class, (String)"HASH", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).initializer("$S", new Object[]{validator.getHash()}).build());
        return fields;
    }

    private List<? extends TypeMirror> getExtendWithValues(ExtendWith extendWith) {
        try {
            extendWith.value();
        }
        catch (MirroredTypesException ex) {
            return ex.getTypeMirrors();
        }
        return null;
    }

    private TypeMirror getExtendWithValue(ExtendWith extendWith) {
        try {
            extendWith.value();
        }
        catch (MirroredTypeException e) {
            return e.getTypeMirror();
        }
        return null;
    }

    private static boolean isParameterizedValidator(Validator validator) {
        return validator.getParameters() != null && validator.getParameters().size() > 0;
    }

    private TypeMirror getTypeMirror(String type) {
        try {
            type.getClass();
        }
        catch (MirroredTypeException e) {
            return e.getTypeMirror();
        }
        return null;
    }

    private void error(Element e, String msg, Object ... args) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }
}

