/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.blockfrost.service;

import com.bloxbean.cardano.client.api.common.OrderEnum;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.api.AccountService;
import com.bloxbean.cardano.client.backend.blockfrost.service.BFBaseService;
import com.bloxbean.cardano.client.backend.blockfrost.service.http.AccountApi;
import com.bloxbean.cardano.client.backend.model.AccountAddress;
import com.bloxbean.cardano.client.backend.model.AccountAsset;
import com.bloxbean.cardano.client.backend.model.AccountHistory;
import com.bloxbean.cardano.client.backend.model.AccountInformation;
import com.bloxbean.cardano.client.backend.model.AccountRewardsHistory;
import java.io.IOException;
import java.util.List;
import retrofit2.Call;
import retrofit2.Response;

public class BFAccountService
extends BFBaseService
implements AccountService {
    private final AccountApi accountApi = (AccountApi)this.getRetrofit().create(AccountApi.class);

    public BFAccountService(String baseUrl, String projectId) {
        super(baseUrl, projectId);
    }

    public Result<AccountInformation> getAccountInformation(String stakeAddress) throws ApiException {
        Call<AccountInformation> call = this.accountApi.getAccountInformation(this.getProjectId(), stakeAddress);
        try {
            Response response = call.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException("Error getting accountInformation", (Exception)e);
        }
    }

    public Result<List<AccountRewardsHistory>> getAccountRewardsHistory(String stakeAddress, int count, int page) throws ApiException {
        return this.getAccountRewardsHistory(stakeAddress, count, page, OrderEnum.asc);
    }

    public Result<List<AccountRewardsHistory>> getAccountRewardsHistory(String stakeAddress, int count, int page, OrderEnum order) throws ApiException {
        Call<List<AccountRewardsHistory>> call = this.accountApi.getAccountRewardsHistory(this.getProjectId(), stakeAddress, count, page, order.toString());
        try {
            Response response = call.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException("Error getting accountInformation", (Exception)e);
        }
    }

    public Result<List<AccountHistory>> getAccountHistory(String stakeAddress, int count, int page) throws ApiException {
        return this.getAccountHistory(stakeAddress, count, page, OrderEnum.asc);
    }

    public Result<List<AccountHistory>> getAccountHistory(String stakeAddress, int count, int page, OrderEnum order) throws ApiException {
        Call<List<AccountHistory>> call = this.accountApi.getAccountHistory(this.getProjectId(), stakeAddress, count, page, order.toString());
        try {
            Response response = call.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException("Error getting accountInformation", (Exception)e);
        }
    }

    public Result<List<AccountAddress>> getAccountAddresses(String stakeAddress, int count, int page) throws ApiException {
        return this.getAccountAddresses(stakeAddress, count, page, OrderEnum.asc);
    }

    public Result<List<AccountAddress>> getAccountAddresses(String stakeAddress, int count, int page, OrderEnum order) throws ApiException {
        Call<List<AccountAddress>> call = this.accountApi.getAccountAddresses(this.getProjectId(), stakeAddress, count, page, order.toString());
        try {
            Response response = call.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException("Error getting accountInformation", (Exception)e);
        }
    }

    public Result<List<AccountAsset>> getAccountAssets(String stakeAddress, int count, int page) throws ApiException {
        return this.getAccountAssets(stakeAddress, count, page, OrderEnum.asc);
    }

    public Result<List<AccountAsset>> getAccountAssets(String stakeAddress, int count, int page, OrderEnum order) throws ApiException {
        Call<List<AccountAsset>> call = this.accountApi.getAccountAssets(this.getProjectId(), stakeAddress, count, page, order.toString());
        try {
            Response response = call.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException("Error getting accountInformation", (Exception)e);
        }
    }
}

