/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.blockfrost.service;

import com.bloxbean.cardano.client.api.common.OrderEnum;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.api.AssetService;
import com.bloxbean.cardano.client.backend.blockfrost.service.BFBaseService;
import com.bloxbean.cardano.client.backend.blockfrost.service.http.AssetsApi;
import com.bloxbean.cardano.client.backend.model.Asset;
import com.bloxbean.cardano.client.backend.model.AssetAddress;
import com.bloxbean.cardano.client.backend.model.PolicyAsset;
import java.io.IOException;
import java.util.List;
import retrofit2.Call;
import retrofit2.Response;

public class BFAssetService
extends BFBaseService
implements AssetService {
    private final AssetsApi assetsApi = (AssetsApi)this.getRetrofit().create(AssetsApi.class);

    public BFAssetService(String baseUrl, String projectId) {
        super(baseUrl, projectId);
    }

    public Result<Asset> getAsset(String assetId) throws ApiException {
        Call<Asset> assetReponse = this.assetsApi.getAsset(this.getProjectId(), assetId);
        try {
            Response response = assetReponse.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException("Error getting asset info", (Exception)e);
        }
    }

    public Result<List<AssetAddress>> getAssetAddresses(String asset, int count, int page, OrderEnum order) throws ApiException {
        this.validateAsset(asset);
        Call<List<AssetAddress>> assetAddressCall = this.assetsApi.assetsAssetAddressesGet(this.getProjectId(), asset, count, page, order.name());
        try {
            Response assetAddressResponse = assetAddressCall.execute();
            return this.processResponse(assetAddressResponse);
        }
        catch (IOException exp) {
            throw new ApiException("Exception while fetching addresses for asset: " + asset, (Exception)exp);
        }
    }

    private void validateAsset(String asset) throws ApiException {
        if (asset == null || asset.equals("")) {
            throw new ApiException("Asset cannot be null or empty");
        }
    }

    public Result<List<AssetAddress>> getAssetAddresses(String asset, int count, int page) throws ApiException {
        return this.getAssetAddresses(asset, count, page, OrderEnum.asc);
    }

    public Result<List<PolicyAsset>> getPolicyAssets(String policyId, int count, int page, OrderEnum order) throws ApiException {
        if (policyId == null || policyId.equals("")) {
            throw new ApiException("PolicyId cannot be null or empty");
        }
        Call<List<PolicyAsset>> policyAssetsCall = this.assetsApi.assetsPolicyPolicyIdGet(this.getProjectId(), policyId, count, page, order.name());
        try {
            Response policyAssetsResponse = policyAssetsCall.execute();
            return this.processResponse(policyAssetsResponse);
        }
        catch (IOException exp) {
            throw new ApiException("Exception while fetching assets for policy: " + policyId, (Exception)exp);
        }
    }

    public Result<List<PolicyAsset>> getPolicyAssets(String policyId, int count, int page) throws ApiException {
        return this.getPolicyAssets(policyId, count, page, OrderEnum.asc);
    }
}

