/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.blockfrost.service;

import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.api.BlockService;
import com.bloxbean.cardano.client.backend.blockfrost.service.BFBaseService;
import com.bloxbean.cardano.client.backend.blockfrost.service.http.BlockApi;
import com.bloxbean.cardano.client.backend.model.Block;
import java.io.IOException;
import java.math.BigInteger;
import retrofit2.Call;
import retrofit2.Response;

public class BFBlockService
extends BFBaseService
implements BlockService {
    private BlockApi blockApi = (BlockApi)this.getRetrofit().create(BlockApi.class);

    public BFBlockService(String baseUrl, String projectId) {
        super(baseUrl, projectId);
    }

    public Result<Block> getLatestBlock() throws ApiException {
        Call<Block> blockCall = this.blockApi.getLatestBlock(this.getProjectId());
        try {
            Response response = blockCall.execute();
            if (response.isSuccessful()) {
                return Result.success((String)response.toString()).withValue(response.body()).code(response.code());
            }
            return Result.error((String)response.errorBody().string()).code(response.code());
        }
        catch (IOException e) {
            throw new ApiException("Error getting latest block", (Exception)e);
        }
    }

    public Result<Block> getBlockByHash(String blockHash) throws ApiException {
        Call<Block> blockCall = this.blockApi.getBlockByHash(this.getProjectId(), blockHash);
        try {
            Response response = blockCall.execute();
            if (response.isSuccessful()) {
                return Result.success((String)response.toString()).withValue(response.body()).code(response.code());
            }
            return Result.error((String)response.errorBody().string()).code(response.code());
        }
        catch (IOException e) {
            throw new ApiException("Error getting block by hash", (Exception)e);
        }
    }

    public Result<Block> getBlockByNumber(BigInteger blockNumber) throws ApiException {
        Call<Block> blockCall = this.blockApi.getBlockByNumber(this.getProjectId(), blockNumber);
        try {
            Response response = blockCall.execute();
            if (response.isSuccessful()) {
                return Result.success((String)response.toString()).withValue(response.body()).code(response.code());
            }
            return Result.error((String)response.errorBody().string()).code(response.code());
        }
        catch (IOException e) {
            throw new ApiException("Error getting block by number", (Exception)e);
        }
    }
}

