/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.blockfrost.service;

import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.api.NetworkInfoService;
import com.bloxbean.cardano.client.backend.blockfrost.service.BFBaseService;
import com.bloxbean.cardano.client.backend.blockfrost.service.http.CardanoLedgerApi;
import com.bloxbean.cardano.client.backend.model.Genesis;
import java.io.IOException;
import retrofit2.Call;
import retrofit2.Response;

public class BFNetworkService
extends BFBaseService
implements NetworkInfoService {
    private final CardanoLedgerApi ledgerApi = (CardanoLedgerApi)this.getRetrofit().create(CardanoLedgerApi.class);

    public BFNetworkService(String baseUrl, String projectId) {
        super(baseUrl, projectId);
    }

    public Result<Genesis> getNetworkInfo() throws ApiException {
        Call<Genesis> genesisCall = this.ledgerApi.genesis(this.getProjectId());
        try {
            Response response = genesisCall.execute();
            if (response.isSuccessful()) {
                return Result.success((String)response.toString()).withValue(response.body()).code(response.code());
            }
            return Result.error((String)response.errorBody().string()).code(response.code());
        }
        catch (IOException e) {
            throw new ApiException("Error getting genesis info", (Exception)e);
        }
    }
}

