/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.blockfrost.service;

import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.EvaluationResult;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.api.TransactionService;
import com.bloxbean.cardano.client.backend.blockfrost.service.BFBaseService;
import com.bloxbean.cardano.client.backend.blockfrost.service.OgmiosTxResponseParser;
import com.bloxbean.cardano.client.backend.blockfrost.service.http.TransactionApi;
import com.bloxbean.cardano.client.backend.model.TransactionContent;
import com.bloxbean.cardano.client.backend.model.TxContentRedeemers;
import com.bloxbean.cardano.client.backend.model.TxContentUtxo;
import com.bloxbean.cardano.client.util.HexUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.Response;

public class BFTransactionService
extends BFBaseService
implements TransactionService {
    private TransactionApi transactionApi = (TransactionApi)this.getRetrofit().create(TransactionApi.class);

    public BFTransactionService(String baseUrl, String projectId) {
        super(baseUrl, projectId);
    }

    public Result<String> submitTransaction(byte[] cborData) throws ApiException {
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/cbor"), (byte[])cborData);
        Call<String> txnCall = this.transactionApi.submit(this.getProjectId(), requestBody);
        try {
            Response response = txnCall.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException("Error submit transaction", (Exception)e);
        }
    }

    public Result<TransactionContent> getTransaction(String txnHash) throws ApiException {
        Call<TransactionContent> txnCall = this.transactionApi.getTransaction(this.getProjectId(), txnHash);
        try {
            Response response = txnCall.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException("Error getting transaction for id : " + txnHash, (Exception)e);
        }
    }

    public Result<List<TransactionContent>> getTransactions(List<String> txnHashCollection) throws ApiException {
        ArrayList<TransactionContent> transactionContentList = new ArrayList<TransactionContent>();
        for (String txnHash : txnHashCollection) {
            if (!txnHash.isEmpty() && !txnHash.matches("^[\\da-fA-F]+$")) {
                throw new ApiException("Invalid Transaction Hash Format");
            }
            Result<TransactionContent> result = this.getTransaction(txnHash);
            if (result.isSuccessful()) {
                transactionContentList.add((TransactionContent)result.getValue());
                continue;
            }
            return Result.error((String)result.getResponse()).code(result.code());
        }
        return Result.success((String)"OK").withValue(transactionContentList).code(200);
    }

    public Result<TxContentUtxo> getTransactionUtxos(String txnHash) throws ApiException {
        Call<TxContentUtxo> txnCall = this.transactionApi.getTransactionUtxos(this.getProjectId(), txnHash);
        try {
            Response response = txnCall.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException("Error getting transaction utxos for id : " + txnHash, (Exception)e);
        }
    }

    public Result<List<TxContentRedeemers>> getTransactionRedeemers(String txnHash) throws ApiException {
        Call<List<TxContentRedeemers>> txnCall = this.transactionApi.getTransactionRedeemers(this.getProjectId(), txnHash);
        try {
            Response response = txnCall.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException("Error getting transaction redeemers for id : " + txnHash, (Exception)e);
        }
    }

    public Result<List<EvaluationResult>> evaluateTx(byte[] cborData) throws ApiException {
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/cbor"), (String)HexUtil.encodeHexString((byte[])cborData));
        Call<Object> evalCall = this.transactionApi.evaluateTx(this.getProjectId(), requestBody);
        try {
            Response response = evalCall.execute();
            return OgmiosTxResponseParser.processEvaluateResponse((Response<Object>)response);
        }
        catch (IOException e) {
            throw new ApiException("Error evaluating script cost for transaction", (Exception)e);
        }
    }
}

