/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.blockfrost.service;

import com.bloxbean.cardano.client.api.common.OrderEnum;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.api.AccountService;
import com.bloxbean.cardano.client.backend.api.AddressService;
import com.bloxbean.cardano.client.backend.blockfrost.service.BFBaseService;
import com.bloxbean.cardano.client.backend.blockfrost.service.http.AccountApi;
import com.bloxbean.cardano.client.backend.model.AccountAddress;
import com.bloxbean.cardano.client.backend.model.AccountAsset;
import com.bloxbean.cardano.client.backend.model.AccountHistory;
import com.bloxbean.cardano.client.backend.model.AccountInformation;
import com.bloxbean.cardano.client.backend.model.AccountRewardsHistory;
import com.bloxbean.cardano.client.backend.model.AddressTransactionContent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import retrofit2.Call;
import retrofit2.Response;

public class BFAccountService
extends BFBaseService
implements AccountService {
    private final AccountApi accountApi = (AccountApi)this.getRetrofit().create(AccountApi.class);
    private final AddressService addressService;

    public BFAccountService(String baseUrl, String projectId, AddressService addressService) {
        super(baseUrl, projectId);
        this.addressService = addressService;
    }

    public Result<AccountInformation> getAccountInformation(String stakeAddress) throws ApiException {
        Call<AccountInformation> call = this.accountApi.getAccountInformation(this.getProjectId(), stakeAddress);
        try {
            Response response = call.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException("Error getting accountInformation", (Exception)e);
        }
    }

    public Result<List<AccountRewardsHistory>> getAccountRewardsHistory(String stakeAddress, int count, int page) throws ApiException {
        return this.getAccountRewardsHistory(stakeAddress, count, page, OrderEnum.asc);
    }

    public Result<List<AccountRewardsHistory>> getAccountRewardsHistory(String stakeAddress, int count, int page, OrderEnum order) throws ApiException {
        Call<List<AccountRewardsHistory>> call = this.accountApi.getAccountRewardsHistory(this.getProjectId(), stakeAddress, count, page, order.toString());
        try {
            Response response = call.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException("Error getting accountInformation", (Exception)e);
        }
    }

    public Result<List<AccountHistory>> getAccountHistory(String stakeAddress, int count, int page) throws ApiException {
        return this.getAccountHistory(stakeAddress, count, page, OrderEnum.asc);
    }

    public Result<List<AccountHistory>> getAccountHistory(String stakeAddress, int count, int page, OrderEnum order) throws ApiException {
        Call<List<AccountHistory>> call = this.accountApi.getAccountHistory(this.getProjectId(), stakeAddress, count, page, order.toString());
        try {
            Response response = call.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException("Error getting accountInformation", (Exception)e);
        }
    }

    public Result<List<AccountAddress>> getAllAccountAddresses(String stakeAddress) throws ApiException {
        ArrayList accountAddresses = new ArrayList();
        int page = 1;
        Result<List<AccountAddress>> accountAddressesResult = this.getAccountAddresses(stakeAddress, 100, page);
        while (accountAddressesResult.isSuccessful()) {
            accountAddresses.addAll((Collection)accountAddressesResult.getValue());
            if (((List)accountAddressesResult.getValue()).size() != 100) break;
            accountAddressesResult = this.getAccountAddresses(stakeAddress, 100, ++page);
        }
        if (!accountAddressesResult.isSuccessful()) {
            return accountAddressesResult;
        }
        return Result.success((String)accountAddressesResult.toString()).withValue(accountAddresses).code(accountAddressesResult.code());
    }

    public Result<List<AccountAddress>> getAccountAddresses(String stakeAddress, int count, int page) throws ApiException {
        return this.getAccountAddresses(stakeAddress, count, page, OrderEnum.asc);
    }

    public Result<List<AccountAddress>> getAccountAddresses(String stakeAddress, int count, int page, OrderEnum order) throws ApiException {
        Call<List<AccountAddress>> call = this.accountApi.getAccountAddresses(this.getProjectId(), stakeAddress, count, page, order.toString());
        try {
            Response response = call.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException("Error getting accountInformation", (Exception)e);
        }
    }

    public Result<List<AccountAsset>> getAllAccountAssets(String stakeAddress) throws ApiException {
        ArrayList accountAssets = new ArrayList();
        int page = 1;
        Result<List<AccountAsset>> accountAssetsResult = this.getAccountAssets(stakeAddress, 100, page);
        while (accountAssetsResult.isSuccessful()) {
            accountAssets.addAll((Collection)accountAssetsResult.getValue());
            if (((List)accountAssetsResult.getValue()).size() != 100) break;
            accountAssetsResult = this.getAccountAssets(stakeAddress, 100, ++page);
        }
        if (!accountAssetsResult.isSuccessful()) {
            return accountAssetsResult;
        }
        return Result.success((String)accountAssetsResult.toString()).withValue(accountAssets).code(accountAssetsResult.code());
    }

    public Result<List<AccountAsset>> getAccountAssets(String stakeAddress, int count, int page) throws ApiException {
        return this.getAccountAssets(stakeAddress, count, page, OrderEnum.asc);
    }

    public Result<List<AccountAsset>> getAccountAssets(String stakeAddress, int count, int page, OrderEnum order) throws ApiException {
        Call<List<AccountAsset>> call = this.accountApi.getAccountAssets(this.getProjectId(), stakeAddress, count, page, order.toString());
        try {
            Response response = call.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException("Error getting accountInformation", (Exception)e);
        }
    }

    public Result<List<AddressTransactionContent>> getAccountTransactions(String stakeAddress, int count, int page, OrderEnum order, Integer fromBlockHeight, Integer toBlockHeight) throws ApiException {
        Result<List<AccountAddress>> accountAddressesResult = this.getAllAccountAddresses(stakeAddress);
        if (accountAddressesResult.isSuccessful()) {
            ArrayList transactionContents = new ArrayList();
            List accountAddresses = (List)accountAddressesResult.getValue();
            try {
                for (AccountAddress accountAddress : accountAddresses) {
                    Result listResult = this.addressService.getTransactions(accountAddress.getAddress(), 100, page, order, fromBlockHeight.toString(), toBlockHeight.toString());
                    if (!listResult.isSuccessful()) continue;
                    transactionContents.addAll((Collection)listResult.getValue());
                }
            }
            catch (ApiException e) {
                throw new RuntimeException(e);
            }
            transactionContents.sort((o1, o2) -> order == OrderEnum.asc ? Long.compare(o1.getBlockHeight(), o2.getBlockHeight()) : Long.compare(o2.getBlockHeight(), o1.getBlockHeight()));
            return Result.success((String)"SUCCESS").withValue(transactionContents).code(200);
        }
        return Result.error((String)accountAddressesResult.getResponse()).code(accountAddressesResult.code());
    }

    public Result<List<AddressTransactionContent>> getAllAccountTransactions(String stakeAddress, OrderEnum order, Integer fromBlockHeight, Integer toBlockHeight) throws ApiException {
        Result<List<AccountAddress>> accountAddressesResult = this.getAllAccountAddresses(stakeAddress);
        if (accountAddressesResult.isSuccessful()) {
            ArrayList transactionContents = new ArrayList();
            List accountAddresses = (List)accountAddressesResult.getValue();
            try {
                for (AccountAddress accountAddress : accountAddresses) {
                    Result listResult = this.addressService.getAllTransactions(accountAddress.getAddress(), order, fromBlockHeight, toBlockHeight);
                    if (!listResult.isSuccessful()) continue;
                    transactionContents.addAll((Collection)listResult.getValue());
                }
            }
            catch (ApiException e) {
                throw new RuntimeException(e);
            }
            transactionContents.sort((o1, o2) -> order == OrderEnum.asc ? Long.compare(o1.getBlockHeight(), o2.getBlockHeight()) : Long.compare(o2.getBlockHeight(), o1.getBlockHeight()));
            return Result.success((String)"SUCCESS").withValue(transactionContents).code(200);
        }
        return Result.error((String)accountAddressesResult.getResponse()).code(accountAddressesResult.code());
    }
}

