/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.blockfrost.service;

import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.ProtocolParams;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.api.EpochService;
import com.bloxbean.cardano.client.backend.blockfrost.service.BFBaseService;
import com.bloxbean.cardano.client.backend.blockfrost.service.http.EpochApi;
import com.bloxbean.cardano.client.backend.model.EpochContent;
import java.io.IOException;
import retrofit2.Call;
import retrofit2.Response;

public class BFEpochService
extends BFBaseService
implements EpochService {
    private EpochApi epochApi = (EpochApi)this.getRetrofit().create(EpochApi.class);

    public BFEpochService(String baseUrl, String projectId) {
        super(baseUrl, projectId);
    }

    public Result<EpochContent> getLatestEpoch() throws ApiException {
        Call<EpochContent> call = this.epochApi.getLatestEpoch(this.getProjectId());
        try {
            Response response = call.execute();
            if (response.isSuccessful()) {
                return Result.success((String)response.toString()).withValue(response.body()).code(response.code());
            }
            return Result.error((String)response.errorBody().string()).code(response.code());
        }
        catch (IOException e) {
            throw new ApiException("Error getting latest epoch", (Exception)e);
        }
    }

    public Result<EpochContent> getEpoch(Integer epoch) throws ApiException {
        Call<EpochContent> call = this.epochApi.getEpochByNumber(this.getProjectId(), epoch);
        try {
            Response response = call.execute();
            if (response.isSuccessful()) {
                return Result.success((String)response.toString()).withValue(response.body()).code(response.code());
            }
            return Result.error((String)response.errorBody().string()).code(response.code());
        }
        catch (IOException e) {
            throw new ApiException("Error getting epoch by number : " + epoch, (Exception)e);
        }
    }

    public Result<ProtocolParams> getProtocolParameters(Integer epoch) throws ApiException {
        Call<ProtocolParams> call = this.epochApi.getProtocolParameters(this.getProjectId(), epoch);
        try {
            Response response = call.execute();
            if (response.isSuccessful()) {
                return Result.success((String)response.toString()).withValue(response.body()).code(response.code());
            }
            return Result.error((String)response.errorBody().string()).code(response.code());
        }
        catch (IOException e) {
            throw new ApiException("Error getting protocol parameters by number : " + epoch, (Exception)e);
        }
    }

    public Result<ProtocolParams> getProtocolParameters() throws ApiException {
        Result<EpochContent> epochContentResult = this.getLatestEpoch();
        if (!epochContentResult.isSuccessful()) {
            throw new ApiException("Unable to get latest epoch info to get protocol parameters");
        }
        EpochContent epochContent = (EpochContent)epochContentResult.getValue();
        if (epochContent == null) {
            throw new ApiException("Unable to get latest epoch info to get protocol parameters");
        }
        return this.getProtocolParameters(epochContent.getEpoch());
    }
}

