/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.blockfrost.service;

import com.bloxbean.cardano.client.api.common.OrderEnum;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.api.AddressService;
import com.bloxbean.cardano.client.backend.blockfrost.service.BFBaseService;
import com.bloxbean.cardano.client.backend.blockfrost.service.http.AddressesApi;
import com.bloxbean.cardano.client.backend.model.AddressContent;
import com.bloxbean.cardano.client.backend.model.AddressDetails;
import com.bloxbean.cardano.client.backend.model.AddressTransactionContent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import retrofit2.Call;
import retrofit2.Response;

public class BFAddressService
extends BFBaseService
implements AddressService {
    private AddressesApi addressApi = (AddressesApi)this.getRetrofit().create(AddressesApi.class);

    public BFAddressService(String baseUrl, String projectId) {
        super(baseUrl, projectId);
    }

    public Result<AddressContent> getAddressInfo(String address) throws ApiException {
        Call<AddressContent> call = this.addressApi.getAddressInfo(this.getProjectId(), address);
        try {
            Response response = call.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException("Error getting addressInfo", (Exception)e);
        }
    }

    public Result<AddressDetails> getAddressDetails(String address) throws ApiException {
        Call<AddressDetails> call = this.addressApi.getAddressDetails(this.getProjectId(), address);
        try {
            Response response = call.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException("Error getting addressInfo", (Exception)e);
        }
    }

    public Result<List<AddressTransactionContent>> getTransactions(String address, int count, int page) throws ApiException {
        return this.getTransactions(address, count, page, OrderEnum.asc);
    }

    public Result<List<AddressTransactionContent>> getTransactions(String address, int count, int page, OrderEnum order) throws ApiException {
        return this.getTransactions(address, count, page, order, null, null);
    }

    public Result<List<AddressTransactionContent>> getTransactions(String address, int count, int page, OrderEnum order, String from, String to) throws ApiException {
        Call<List<AddressTransactionContent>> call = this.addressApi.getTransactions(this.getProjectId(), address, count, page, order.toString(), from, to);
        try {
            Response response = call.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException("Error getting transactions for the address", (Exception)e);
        }
    }

    public Result<List<AddressTransactionContent>> getAllTransactions(String address, OrderEnum order, Integer fromBlockHeight, Integer toBlockHeight) throws ApiException {
        ArrayList addressTransactionContents = new ArrayList();
        int page = 1;
        Result<List<AddressTransactionContent>> addressTransactionContentsResult = this.getTransactions(address, 100, page, order, String.valueOf(fromBlockHeight), String.valueOf(toBlockHeight));
        while (addressTransactionContentsResult.isSuccessful()) {
            addressTransactionContents.addAll((Collection)addressTransactionContentsResult.getValue());
            if (((List)addressTransactionContentsResult.getValue()).size() != 100) break;
            addressTransactionContentsResult = this.getTransactions(address, 100, ++page, order, String.valueOf(fromBlockHeight), String.valueOf(toBlockHeight));
        }
        if (!addressTransactionContentsResult.isSuccessful()) {
            return addressTransactionContentsResult;
        }
        addressTransactionContents.sort((o1, o2) -> order == OrderEnum.asc ? Long.compare(o1.getBlockHeight(), o2.getBlockHeight()) : Long.compare(o2.getBlockHeight(), o1.getBlockHeight()));
        return Result.success((String)addressTransactionContentsResult.toString()).withValue(addressTransactionContents).code(addressTransactionContentsResult.code());
    }
}

