/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.blockfrost.service;

import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.api.ScriptService;
import com.bloxbean.cardano.client.backend.blockfrost.service.BFBaseService;
import com.bloxbean.cardano.client.backend.blockfrost.service.http.ScriptApi;
import com.bloxbean.cardano.client.backend.model.ScriptDatum;
import com.bloxbean.cardano.client.backend.model.ScriptDatumCbor;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import retrofit2.Call;
import retrofit2.Response;

public class BFScriptService
extends BFBaseService
implements ScriptService {
    private ScriptApi scriptApi = (ScriptApi)this.getRetrofit().create(ScriptApi.class);

    public BFScriptService(String baseUrl, String projectId) {
        super(baseUrl, projectId);
    }

    public Result<ScriptDatum> getScriptDatum(String datumHash) throws ApiException {
        Call<ScriptDatum> call = this.scriptApi.getDatumValue(this.getProjectId(), datumHash);
        try {
            Response response = call.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException("Exception while fetching script datum for hash: " + datumHash, (Exception)e);
        }
    }

    public Result<ScriptDatumCbor> getScriptDatumCbor(String datumHash) throws ApiException {
        Call<ScriptDatumCbor> call = this.scriptApi.getDatumValueCbor(this.getProjectId(), datumHash);
        try {
            Response response = call.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException("Exception while fetching script datum cbor for hash: " + datumHash, (Exception)e);
        }
    }

    public Result<JsonNode> getNativeScriptJson(String scriptHash) throws ApiException {
        Call<JsonNode> call = this.scriptApi.getScriptJson(this.getProjectId(), scriptHash);
        try {
            Response response = call.execute();
            Result result = this.processResponse(response);
            if (result.isSuccessful() && result.getValue() != null) {
                JsonNode rootNode = (JsonNode)result.getValue();
                JsonNode jsonNode = rootNode.get("json");
                String jsonNodeStr = jsonNode != null ? jsonNode.toString() : "";
                return Result.success((String)jsonNodeStr).withValue((Object)jsonNode).code(result.code());
            }
            return result;
        }
        catch (IOException e) {
            throw new ApiException("Exception while fetching script for hash: " + scriptHash, (Exception)e);
        }
    }

    public Result<String> getPlutusScriptCbor(String scriptHash) throws ApiException {
        Call<JsonNode> call = this.scriptApi.getScriptCbor(this.getProjectId(), scriptHash);
        try {
            Response response = call.execute();
            Result result = this.processResponse(response);
            if (result.isSuccessful() && result.getValue() != null) {
                JsonNode rootNode = (JsonNode)result.getValue();
                JsonNode cborNode = rootNode.get("cbor");
                String cbor = cborNode != null ? cborNode.asText() : "";
                return Result.success((String)cbor).withValue((Object)cbor).code(result.code());
            }
            return Result.error((String)"cbor not found").code(result.code());
        }
        catch (IOException e) {
            throw new ApiException("Exception while fetching script for hash: " + scriptHash, (Exception)e);
        }
    }
}

