/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.blockfrost.service;

import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.api.PoolService;
import com.bloxbean.cardano.client.backend.blockfrost.service.BFBaseService;
import com.bloxbean.cardano.client.backend.blockfrost.service.http.PoolApi;
import com.bloxbean.cardano.client.backend.model.PoolInfo;
import java.io.IOException;
import retrofit2.Call;
import retrofit2.Response;

public class BFPoolService
extends BFBaseService
implements PoolService {
    private final PoolApi poolApi = (PoolApi)this.getRetrofit().create(PoolApi.class);

    public BFPoolService(String baseUrl, String projectId) {
        super(baseUrl, projectId);
    }

    public Result<PoolInfo> getPoolInfo(String poolId) throws ApiException {
        Call<PoolInfo> poolInfoCall = this.poolApi.getPoolInfo(this.getProjectId(), poolId);
        try {
            Response response = poolInfoCall.execute();
            if (response.isSuccessful()) {
                return Result.success((String)response.toString()).withValue(response.body()).code(response.code());
            }
            return Result.error((String)response.errorBody().string()).code(response.code());
        }
        catch (IOException e) {
            throw new ApiException("Error getting Pool Info by Pool Id", (Exception)e);
        }
    }
}

