/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.blockfrost.service;

import com.bloxbean.cardano.client.api.common.OrderEnum;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.backend.api.TransactionService;
import com.bloxbean.cardano.client.backend.api.UtxoService;
import com.bloxbean.cardano.client.backend.blockfrost.service.BFBaseService;
import com.bloxbean.cardano.client.backend.blockfrost.service.BFTransactionService;
import com.bloxbean.cardano.client.backend.blockfrost.service.http.AddressesApi;
import com.bloxbean.cardano.client.backend.model.AddressTransactionContent;
import java.io.IOException;
import java.util.List;
import retrofit2.Call;
import retrofit2.Response;

public class BFUtxoService
extends BFBaseService
implements UtxoService {
    private AddressesApi addressApi = (AddressesApi)this.getRetrofit().create(AddressesApi.class);
    private TransactionService transactionService;

    public BFUtxoService(String baseUrl, String projectId) {
        super(baseUrl, projectId);
        this.transactionService = new BFTransactionService(baseUrl, projectId);
    }

    public Result<List<Utxo>> getUtxos(String address, int count, int page) throws ApiException {
        return this.getUtxos(address, count, page, OrderEnum.asc);
    }

    public Result<List<Utxo>> getUtxos(String address, int count, int page, OrderEnum order) throws ApiException {
        Call<List<Utxo>> utxosCall = this.addressApi.getUtxos(this.getProjectId(), address, count, page, order.toString());
        try {
            Response response = utxosCall.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException("Error getting utxos", (Exception)e);
        }
    }

    public Result<List<Utxo>> getUtxos(String address, String unit, int count, int page) throws ApiException {
        return this.getUtxos(address, unit, count, page, OrderEnum.asc);
    }

    public Result<List<Utxo>> getUtxos(String address, String unit, int count, int page, OrderEnum order) throws ApiException {
        Call<List<Utxo>> utxosCall = this.addressApi.getUtxosByAsset(this.getProjectId(), address, unit, count, page, order.toString());
        try {
            Response response = utxosCall.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException("Error getting utxos for address : " + address + ", asset: " + unit, (Exception)e);
        }
    }

    public Result<Utxo> getTxOutput(String txHash, int outputIndex) throws ApiException {
        return this.transactionService.getTransactionOutput(txHash, outputIndex);
    }

    public boolean isUsedAddress(String address) throws ApiException {
        Call<List<AddressTransactionContent>> call = this.addressApi.getTransactions(this.getProjectId(), address, 1, 1, OrderEnum.asc.toString(), null, null);
        try {
            Response response = call.execute();
            Result txList = this.processResponse(response);
            return txList.isSuccessful() && ((List)txList.getValue()).size() > 0;
        }
        catch (IOException e) {
            throw new ApiException("Error checking transaction history for address : " + address, (Exception)e);
        }
    }
}

