/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.koios;

import com.bloxbean.cardano.client.api.common.OrderEnum;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.api.AddressService;
import com.bloxbean.cardano.client.backend.model.AddressContent;
import com.bloxbean.cardano.client.backend.model.AddressTransactionContent;
import com.bloxbean.cardano.client.backend.model.TxContentOutputAmount;
import java.lang.invoke.CallSite;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import rest.koios.client.backend.api.address.model.AddressInfo;
import rest.koios.client.backend.api.address.model.AddressUtxo;
import rest.koios.client.backend.api.common.Asset;
import rest.koios.client.backend.api.common.TxHash;
import rest.koios.client.backend.factory.options.Limit;
import rest.koios.client.backend.factory.options.Offset;
import rest.koios.client.backend.factory.options.Option;
import rest.koios.client.backend.factory.options.Options;
import rest.koios.client.backend.factory.options.Order;
import rest.koios.client.backend.factory.options.SortType;
import rest.koios.client.backend.factory.options.filters.Filter;
import rest.koios.client.backend.factory.options.filters.FilterType;

public class KoiosAddressService
implements AddressService {
    private final rest.koios.client.backend.api.address.AddressService addressService;

    public KoiosAddressService(rest.koios.client.backend.api.address.AddressService addressService) {
        this.addressService = addressService;
    }

    public Result<AddressContent> getAddressInfo(String address) throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result addressInformationResult = this.addressService.getAddressInformation(address);
            if (!addressInformationResult.isSuccessful()) {
                return Result.error((String)addressInformationResult.getResponse()).code(addressInformationResult.getCode());
            }
            return this.convertToAddressContent((AddressInfo)addressInformationResult.getValue());
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private Result<AddressContent> convertToAddressContent(AddressInfo addressInfo) {
        AddressContent addressContent = new AddressContent();
        addressContent.setStakeAddress(addressInfo.getStakeAddress());
        if (addressContent.getStakeAddress() == null || addressContent.getStakeAddress().isEmpty()) {
            addressContent.setType(AddressContent.TypeEnum.BYRON);
        } else {
            addressContent.setType(AddressContent.TypeEnum.SHELLEY);
        }
        HashMap<CallSite, TxContentOutputAmount> assetMap = new HashMap<CallSite, TxContentOutputAmount>();
        for (AddressUtxo addressUtxo : addressInfo.getUtxoSet()) {
            for (Asset asset : addressUtxo.getAssetList()) {
                String key = asset.getPolicyId() + asset.getAssetName();
                if (assetMap.containsKey(key)) {
                    ((TxContentOutputAmount)assetMap.get(key)).setQuantity(String.valueOf(Long.parseLong(((TxContentOutputAmount)assetMap.get(key)).getQuantity()) + Long.parseLong(asset.getQuantity())));
                    continue;
                }
                assetMap.put((CallSite)((Object)key), new TxContentOutputAmount(key, asset.getQuantity()));
            }
        }
        ArrayList txContentOutputAmountList = new ArrayList(assetMap.values());
        txContentOutputAmountList.sort(Comparator.comparing(TxContentOutputAmount::getUnit));
        txContentOutputAmountList.add(0, new TxContentOutputAmount("lovelace", addressInfo.getBalance()));
        addressContent.setAmount(txContentOutputAmountList);
        addressContent.setScript(addressInfo.getScriptAddress());
        return Result.success((String)"OK").withValue((Object)addressContent).code(200);
    }

    public Result<List<AddressTransactionContent>> getTransactions(String address, int count, int page) throws ApiException {
        return this.getTransactions(address, count, page, OrderEnum.asc);
    }

    public Result<List<AddressTransactionContent>> getTransactions(String address, int count, int page, OrderEnum order) throws ApiException {
        return this.getTransactions(address, count, page, order, null, null);
    }

    public Result<List<AddressTransactionContent>> getTransactions(String address, int count, int page, OrderEnum order, String from, String to) throws ApiException {
        try {
            rest.koios.client.backend.api.base.Result transactionsResult;
            Order ordering = Order.by((String)"block_height", (SortType)SortType.ASC);
            if (order == OrderEnum.desc) {
                ordering = Order.by((String)"block_height", (SortType)SortType.DESC);
            }
            Options options = Options.builder().option((Option)Limit.of((long)count)).option((Option)Offset.of((long)((long)(page - 1) * (long)count))).option((Option)ordering).build();
            if (from != null && !from.isEmpty()) {
                options.getOptions().add(Filter.of((String)"block_height", (FilterType)FilterType.GTE, (String)from));
            }
            if (to != null && !to.isEmpty()) {
                options.getOptions().add(Filter.of((String)"block_height", (FilterType)FilterType.LTE, (String)to));
            }
            if (!(transactionsResult = this.addressService.getAddressTransactions(List.of(address), options)).isSuccessful()) {
                return Result.error((String)transactionsResult.getResponse()).code(transactionsResult.getCode());
            }
            return this.convertToAddressTransactionContent((List)transactionsResult.getValue());
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ParseException e) {
            throw new ApiException("Failed to Parse Date: " + e.getMessage(), (Exception)e);
        }
    }

    private Result<List<AddressTransactionContent>> convertToAddressTransactionContent(List<TxHash> transactions) throws ParseException {
        ArrayList<AddressTransactionContent> addressTransactionContents = new ArrayList<AddressTransactionContent>();
        for (TxHash txHash : transactions) {
            AddressTransactionContent addressTransactionContent = new AddressTransactionContent();
            addressTransactionContent.setTxHash(txHash.getTxHash());
            addressTransactionContent.setBlockHeight((long)txHash.getBlockHeight().intValue());
            addressTransactionContent.setBlockTime((long)txHash.getBlockTime().intValue());
            addressTransactionContents.add(addressTransactionContent);
        }
        return Result.success((String)"OK").withValue(addressTransactionContents).code(200);
    }
}

