/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.koios;

import com.bloxbean.cardano.client.api.common.OrderEnum;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.api.AssetService;
import com.bloxbean.cardano.client.backend.model.Asset;
import com.bloxbean.cardano.client.backend.model.AssetAddress;
import com.bloxbean.cardano.client.backend.model.PolicyAsset;
import com.bloxbean.cardano.client.util.AssetUtil;
import com.bloxbean.cardano.client.util.Tuple;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import rest.koios.client.backend.api.asset.model.AssetInformation;
import rest.koios.client.backend.factory.options.Limit;
import rest.koios.client.backend.factory.options.Offset;
import rest.koios.client.backend.factory.options.Option;
import rest.koios.client.backend.factory.options.Options;

public class KoiosAssetService
implements AssetService {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final rest.koios.client.backend.api.asset.AssetService assetService;

    public KoiosAssetService(rest.koios.client.backend.api.asset.AssetService assetService) {
        this.assetService = assetService;
    }

    public Result<Asset> getAsset(String unit) throws ApiException {
        try {
            Tuple assetTuple = AssetUtil.getPolicyIdAndAssetName((String)unit);
            rest.koios.client.backend.api.base.Result assetInformation = this.assetService.getAssetInformation((String)assetTuple._1, ((String)assetTuple._2).replace("0x", ""));
            if (!assetInformation.isSuccessful()) {
                return Result.error((String)assetInformation.getResponse()).code(assetInformation.getCode());
            }
            return this.convertToAsset((AssetInformation)assetInformation.getValue());
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private Result<Asset> convertToAsset(AssetInformation assetInformation) {
        Asset asset = new Asset();
        asset.setAsset(assetInformation.getPolicyId() + assetInformation.getAssetName());
        asset.setPolicyId(assetInformation.getPolicyId());
        asset.setAssetName(assetInformation.getAssetName());
        asset.setFingerprint(assetInformation.getFingerprint());
        asset.setQuantity(assetInformation.getTotalSupply());
        asset.setInitialMintTxHash(assetInformation.getMintingTxHash());
        asset.setMintOrBurnCount(Integer.valueOf(assetInformation.getMintCnt() + assetInformation.getBurnCnt()));
        if (assetInformation.getMintingTxMetadata() != null) {
            asset.setOnchainMetadata(assetInformation.getMintingTxMetadata());
        }
        if (assetInformation.getTokenRegistryMetadata() != null) {
            asset.setMetadata((JsonNode)this.objectMapper.convertValue((Object)assetInformation.getTokenRegistryMetadata(), JsonNode.class));
        }
        return Result.success((String)"OK").withValue((Object)asset).code(200);
    }

    public Result<List<AssetAddress>> getAllAssetAddresses(String asset) throws ApiException {
        this.validateAsset(asset);
        ArrayList assetAddresses = new ArrayList();
        int page = 1;
        Result<List<AssetAddress>> assetAddressesResult = this.getAssetAddresses(asset, 1000, page);
        while (assetAddressesResult.isSuccessful()) {
            assetAddresses.addAll((Collection)assetAddressesResult.getValue());
            if (((List)assetAddressesResult.getValue()).size() != 1000) break;
            assetAddressesResult = this.getAssetAddresses(asset, 1000, ++page);
        }
        if (!assetAddressesResult.isSuccessful()) {
            return assetAddressesResult;
        }
        return Result.success((String)assetAddressesResult.toString()).withValue(assetAddresses).code(assetAddressesResult.code());
    }

    public Result<List<AssetAddress>> getAssetAddresses(String unit, int count, int page, OrderEnum order) throws ApiException {
        try {
            Tuple assetTuple = AssetUtil.getPolicyIdAndAssetName((String)unit);
            Options options = Options.builder().option((Option)Limit.of((long)count)).option((Option)Offset.of((long)((long)(page - 1) * (long)count))).build();
            rest.koios.client.backend.api.base.Result assetsAddressList = this.assetService.getAssetsAddressList((String)assetTuple._1, ((String)assetTuple._2).replace("0x", ""), options);
            if (!assetsAddressList.isSuccessful()) {
                return Result.error((String)assetsAddressList.getResponse()).code(assetsAddressList.getCode());
            }
            return this.convertToAssetAddresses((List)assetsAddressList.getValue());
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public Result<List<AssetAddress>> getAssetAddresses(String asset, int count, int page) throws ApiException {
        return this.getAssetAddresses(asset, count, page, null);
    }

    private Result<List<AssetAddress>> convertToAssetAddresses(List<rest.koios.client.backend.api.asset.model.AssetAddress> assetAddresses) {
        ArrayList assetAddressList = new ArrayList();
        assetAddresses.forEach(element -> assetAddressList.add(new AssetAddress(element.getPaymentAddress(), element.getQuantity())));
        return Result.success((String)"OK").withValue(assetAddressList).code(200);
    }

    public Result<List<PolicyAsset>> getAllPolicyAssets(String policyId) throws ApiException {
        ArrayList policyAssets = new ArrayList();
        int page = 1;
        Result<List<PolicyAsset>> policyAssetsResult = this.getPolicyAssets(policyId, 1000, page);
        while (policyAssetsResult.isSuccessful()) {
            policyAssets.addAll((Collection)policyAssetsResult.getValue());
            if (((List)policyAssetsResult.getValue()).size() != 1000) break;
            policyAssetsResult = this.getPolicyAssets(policyId, 1000, ++page);
        }
        if (!policyAssetsResult.isSuccessful()) {
            return policyAssetsResult;
        }
        return Result.success((String)policyAssetsResult.toString()).withValue(policyAssets).code(policyAssetsResult.code());
    }

    public Result<List<PolicyAsset>> getPolicyAssets(String policyId, int count, int page, OrderEnum order) throws ApiException {
        try {
            Options options = Options.builder().option((Option)Limit.of((long)count)).option((Option)Offset.of((long)((long)(page - 1) * (long)count))).build();
            rest.koios.client.backend.api.base.Result assetPolicyInfoResult = this.assetService.getAssetPolicyInformation(policyId, options);
            if (!assetPolicyInfoResult.isSuccessful()) {
                return Result.error((String)assetPolicyInfoResult.getResponse()).code(assetPolicyInfoResult.getCode());
            }
            return this.convertToPolicyAssetList(policyId, (List)assetPolicyInfoResult.getValue());
        }
        catch (rest.koios.client.backend.api.base.exception.ApiException e) {
            throw new ApiException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public Result<List<PolicyAsset>> getPolicyAssets(String policyId, int count, int page) throws ApiException {
        return this.getPolicyAssets(policyId, count, page, null);
    }

    private Result<List<PolicyAsset>> convertToPolicyAssetList(String policyId, List<rest.koios.client.backend.api.asset.model.PolicyAsset> policyAssets) {
        ArrayList policyAssetList = new ArrayList();
        if (policyAssets != null) {
            policyAssets.forEach(policyAsset -> policyAssetList.add(new PolicyAsset(policyId + policyAsset.getAssetName(), policyAsset.getTotalSupply())));
        }
        return Result.success((String)"OK").withValue(policyAssetList).code(200);
    }

    private void validateAsset(String asset) throws ApiException {
        if (asset == null || asset.equals("")) {
            throw new ApiException("Asset cannot be null or empty");
        }
    }
}

